/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;
    private static final int CURRENT_ASTERISK_COL = 0;
    private static final int FILE_GROUP_COL = 1;
    private static final int LINE_NUMBER_COL = 2;
    private static final int USAGE_TEXT_COL = 3;

    ShowUsagesTableCellRenderer(@NotNull UsageViewImpl usageView, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        this.myUsageView = usageView;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope;
    }

    @Override
    @DirtyUI
    public Component getTableCellRendererComponent(JTable list2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Color rowForeground;
        UsageNode usageNode = value2 instanceof UsageNode ? (UsageNode)value2 : null;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        Color selectionBg = UIUtil.getListSelectionBackground((boolean)true);
        Color selectionFg = UIUtil.getListSelectionForeground();
        Color rowBackground = isSelected ? selectionBg : (fileBgColor == null ? list2.getBackground() : fileBgColor);
        Color color = rowForeground = isSelected ? selectionFg : list2.getForeground();
        if (usageNode == null || usageNode instanceof ShowUsagesAction.StringNode) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append(ObjectUtils.notNull((Object)value2, (Object)"").toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ((ShowUsagesTable)((Object)list2)).MORE_USAGES_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append("more usages", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ((ShowUsagesTable)((Object)list2)).USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(UsageViewManagerImpl.outOfScopeMessage((int)this.myOutOfScopeUsages.get(), (SearchScope)this.mySearchScope), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ((ShowUsagesTable)((Object)list2)).USAGES_FILTERED_OUT_SEPARATOR) {
            ShowUsagesAction.FilteredOutUsagesNode filtered2 = (ShowUsagesAction.FilteredOutUsagesNode)usageNode;
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append(filtered2.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            JComponent component2 = ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
            component2.setToolTipText(filtered2.getTooltip());
            return component2;
        }
        LayoutManager layout = column == 3 ? new BorderLayout() : new FlowLayout(column == 2 ? 2 : 0, 0, 0){

            @Override
            public void layoutContainer(Container container2) {
                super.layoutContainer(container2);
                for (Component component2 : container2.getComponents()) {
                    Rectangle b = component2.getBounds();
                    Insets insets = container2.getInsets();
                    component2.setBounds(b.x, b.y, b.width, container2.getSize().height - insets.top - insets.bottom);
                }
            }
        };
        JPanel panel2 = new JPanel(layout);
        panel2.setFont(null);
        boolean isOriginUsage = this.myUsageView.isOriginUsage(usage);
        if (isOriginUsage) {
            rowBackground = ShowUsagesTableCellRenderer.slightlyDifferentColor(rowBackground);
            if (fileBgColor != null) {
                fileBgColor = ShowUsagesTableCellRenderer.slightlyDifferentColor(fileBgColor);
            }
            selectionBg = ShowUsagesTableCellRenderer.slightlyDifferentColor(selectionBg);
        }
        panel2.setBackground(rowBackground);
        panel2.setForeground(rowForeground);
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        UsagePresentation presentation2 = usage.getPresentation();
        TextChunk[] text = presentation2.getText();
        switch (column) {
            case 0: {
                if (!isOriginUsage) break;
                panel2.add(new JLabel(isSelected ? AllIcons.General.ModifiedSelected : AllIcons.General.Modified));
                break;
            }
            case 1: {
                this.appendGroupText(list2, (GroupNode)usageNode.getParent(), panel2, fileBgColor, isSelected);
                break;
            }
            case 2: {
                if (text.length != 0) {
                    TextChunk chunk = text[0];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                break;
            }
            case 3: {
                Icon icon2 = presentation2.getIcon();
                textChunks.setIcon(icon2 == null ? EmptyIcon.ICON_16 : icon2);
                textChunks.append("").appendTextPadding(JBUIScale.scale((int)21));
                for (int i2 = 1; i2 < text.length; ++i2) {
                    TextChunk chunk = text[i2];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                if (!isOriginUsage) break;
                SimpleColoredComponent origin = new SimpleColoredComponent();
                origin.setIconTextGap(JBUIScale.scale((int)5));
                SimpleTextAttributes attributes = text.length == 0 ? SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, new Color(0x808080), null, null) : ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, text[0]);
                origin.append("| Current", attributes);
                origin.appendTextPadding(JBUIScale.scale((int)45));
                panel2.add((Component)origin, "East");
                break;
            }
            default: {
                throw new IllegalStateException("unknown column: " + column);
            }
        }
        return panel2;
    }

    @NotNull
    private static Color slightlyDifferentColor(@NotNull Color back) {
        return EditorColorsManager.getInstance().isDarkEditor() ? ColorUtil.brighter((Color)back, (int)3) : ColorUtil.hackBrightness((Color)back, (int)1, (float)0.952381f);
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(boolean isSelected, Color fileBgColor, Color selectionBg, Color selectionFg, @NotNull TextChunk chunk) {
        SimpleTextAttributes background = chunk.getSimpleAttributesIgnoreBackground();
        return isSelected ? new SimpleTextAttributes(selectionBg, selectionFg, null, background.getStyle()) : ShowUsagesTableCellRenderer.deriveBgColor(background, fileBgColor);
    }

    @NotNull
    private static JComponent textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color rowBackground, Color rowForeground, final int column, final @NotNull JTable table) {
        SimpleColoredComponent component2 = new SimpleColoredComponent(){

            protected void doPaint(Graphics2D g) {
                int offset = 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i2 = 0; i2 < column; ++i2) {
                    offset += columnModel.getColumn(i2).getWidth();
                }
                g.translate(-offset, 0);
                this.setSize(this.getWidth() + offset, this.getHeight());
                super.doPaint(g);
                g.translate(offset, 0);
            }

            @NotNull
            public Dimension getPreferredSize() {
                return column == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        component2.setBackground(rowBackground);
        component2.setForeground(rowForeground);
        SimpleColoredComponent.ColoredIterator iterator2 = chunks.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            String fragment = iterator2.getFragment();
            SimpleTextAttributes attributes = iterator2.getTextAttributes();
            attributes = attributes.derive(attributes.getStyle(), rowForeground, rowBackground, attributes.getWaveColor());
            component2.append(fragment, attributes);
        }
        return component2;
    }

    @NotNull
    private static SimpleTextAttributes deriveBgColor(@NotNull SimpleTextAttributes attributes, @Nullable Color fileBgColor) {
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        return attributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground((boolean)true);
        } else {
            Project project;
            Color color;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile != null && (color = VfsPresentationUtil.getFileBackgroundColor(project = this.myUsageView.getProject(), virtualFile)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private void appendGroupText(@NotNull JTable table, GroupNode node, @NotNull JPanel panel2, Color fileBgColor, boolean isSelected) {
        UsageGroup group;
        UsageGroup usageGroup = group = node == null ? null : node.getGroup();
        if (group == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node.getParent();
        this.appendGroupText(table, parentGroup, panel2, fileBgColor, isSelected);
        if (node.canNavigateToSource()) {
            SimpleColoredComponent renderer = new SimpleColoredComponent();
            renderer.setIcon(group.getIcon(false));
            SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveBgColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
            renderer.append(group.getText((UsageView)this.myUsageView), attributes);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)renderer, (boolean)false, (boolean)isSelected);
            panel2.add((Component)renderer);
        }
    }
}

