/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance(ProductivityFeaturesRegistry.class);
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<Pair<String, ApplicabilityFilter>> myApplicabilityFilters = new ArrayList<Pair<String, ApplicabilityFilter>>();
    private boolean myAdditionalFeaturesLoaded = false;
    @NonNls
    public static final String WELCOME = "features.welcome";
    @NonNls
    private static final String TAG_FILTER = "filter";
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";
    @NonNls
    private static final String TODO_HTML_MARKER = "todo.html";
    @NonNls
    private static final String CLASS_ATTR = "class";
    @NonNls
    private static final String PREFIX_ATTR = "prefix";

    public ProductivityFeaturesRegistryImpl() {
        this.reloadFromXml();
    }

    private void reloadFromXml() {
        try {
            this.readFromXml("/ProductivityFeaturesRegistry.xml");
        }
        catch (FileNotFoundException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        try {
            this.readFromXml("/IdeSpecificFeatures.xml");
        }
        catch (FileNotFoundException e) {
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private void readFromXml(@NotNull String path) throws JDOMException, IOException {
        this.readFromXml(path, ProductivityFeaturesRegistryImpl.class);
    }

    private void readFromXml(@NotNull String path, @NotNull Class<?> clazz) throws JDOMException, IOException {
        Element root = JDOMUtil.load(clazz, (String)path);
        for (Element groupElement : root.getChildren(TAG_GROUP)) {
            this.readGroup(groupElement);
        }
        this.readFilters(root);
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        if (this.myAdditionalFeaturesLoaded) {
            return;
        }
        this.myAdditionalFeaturesLoaded = true;
        this.loadFeaturesFromProviders(ProductivityFeaturesProvider.EP_NAME.getExtensionList());
    }

    private void loadFeaturesFromProviders(@NotNull List<ProductivityFeaturesProvider> providers) {
        for (ProductivityFeaturesProvider provider : providers) {
            ApplicabilityFilter[] applicabilityFilters;
            FeatureDescriptor[] featureDescriptors;
            for (GroupDescriptor[] xmlUrl : provider.getXmlFilesUrls()) {
                try {
                    this.readFromXml((String)xmlUrl, provider.getClass());
                }
                catch (Exception e) {
                    LOG.error("Error while reading " + (String)xmlUrl + " from " + provider + ": " + e.getMessage());
                }
            }
            GroupDescriptor[] groupDescriptors = provider.getGroupDescriptors();
            if (groupDescriptors != null) {
                for (GroupDescriptor groupDescriptor : groupDescriptors) {
                    this.myGroups.put(groupDescriptor.getId(), groupDescriptor);
                }
            }
            if ((featureDescriptors = provider.getFeatureDescriptors()) != null) {
                for (FeatureDescriptor featureDescriptor : featureDescriptors) {
                    FeatureDescriptor featureLoadedStatistics = this.myFeatures.get(featureDescriptor.getId());
                    if (featureLoadedStatistics != null) {
                        featureDescriptor.copyStatistics(featureLoadedStatistics);
                    }
                    this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
                }
            }
            if ((applicabilityFilters = provider.getApplicabilityFilters()) == null) continue;
            for (ApplicabilityFilter applicabilityFilter : applicabilityFilters) {
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)applicabilityFilter.getPrefix(), (Object)applicabilityFilter));
            }
        }
    }

    private void readFilters(Element element2) {
        for (Element filterElement : element2.getChildren(TAG_FILTER)) {
            String className = filterElement.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> klass = Class.forName(className);
                if (!ApplicabilityFilter.class.isAssignableFrom(klass)) {
                    LOG.error("filter class must implement com.intellij.featureStatistics.ApplicabilityFilter");
                    continue;
                }
                ApplicabilityFilter filter2 = (ApplicabilityFilter)klass.newInstance();
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)filterElement.getAttributeValue(PREFIX_ATTR), (Object)filter2));
            }
            catch (Exception e) {
                LOG.error("Cannot instantiate filter " + className, (Throwable)e);
            }
        }
    }

    private void readGroup(Element groupElement) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId2 = groupDescriptor.getId();
        this.myGroups.put(groupId2, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor) {
        for (Element featureElement : groupElement.getChildren(TAG_FEATURE)) {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor);
            featureDescriptor.readExternal(featureElement);
            if (TODO_HTML_MARKER.equals(featureDescriptor.getTipFileName())) continue;
            this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
        }
    }

    @NotNull
    public Set<String> getFeatureIds() {
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myFeatures.keySet();
    }

    public FeatureDescriptor getFeatureDescriptor(@NotNull String id2) {
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.getFeatureDescriptorEx(id2);
    }

    public FeatureDescriptor getFeatureDescriptorEx(@NotNull String id2) {
        if (WELCOME.equals(id2)) {
            return new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message((String)"feature.statistics.welcome.tip.name", (Object[])new Object[0]));
        }
        return this.myFeatures.get(id2);
    }

    public GroupDescriptor getGroupDescriptor(@NotNull String id2) {
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myGroups.get(id2);
    }

    public ApplicabilityFilter @NotNull [] getMatchingFilters(@NotNull String featureId) {
        this.lazyLoadFromPluginsFeaturesProviders();
        ArrayList<Object> filters = new ArrayList<Object>();
        for (Pair<String, ApplicabilityFilter> pair : this.myApplicabilityFilters) {
            if (!featureId.startsWith((String)pair.getFirst())) continue;
            filters.add(pair.getSecond());
        }
        return filters.toArray(new ApplicabilityFilter[0]);
    }

    public String toString() {
        return super.toString() + "; myAdditionalFeaturesLoaded=" + this.myAdditionalFeaturesLoaded;
    }

    public void prepareForTest() {
        this.myAdditionalFeaturesLoaded = false;
        this.myFeatures.clear();
        this.myApplicabilityFilters.clear();
        this.myGroups.clear();
        this.reloadFromXml();
    }
}

