/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.ui.content.Content;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RestoreViewAction
extends DumbAwareToggleAction {
    private final RunnerContentUi myUi;
    private final Content myContent;

    public RestoreViewAction(@NotNull RunnerContentUi ui, @NotNull Content content2) {
        this.myUi = ui;
        this.myContent = content2;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.myContent.isValid() && Objects.requireNonNull(this.myContent.getManager()).getIndexOfContent(this.myContent) != -1;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (state) {
            this.myUi.restore(this.myContent);
        } else {
            this.myUi.minimize(this.myContent, null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText(this.myContent.getDisplayName());
        if (this.isSelected(e)) {
            e.getPresentation().setEnabled(this.myUi.getContentManager().getContents().length > 1);
        }
    }

    public Content getContent() {
        return this.myContent;
    }
}

