/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.TagButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WrapLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BeforeRunComponent
extends JPanel
implements DnDTarget {
    private List<TaskButton> myTags;
    private final InplaceButton myAddButton;
    private final JPanel myAddPanel;
    private final LinkLabel<Object> myAddLabel;
    private final JLabel myDropFirst = new JLabel(AllIcons.General.DropPlace);
    Runnable myChangeListener;
    private BiConsumer<Key<? extends BeforeRunTask<?>>, Boolean> myTagListener;
    private RunConfiguration myConfiguration;

    public BeforeRunComponent(@NotNull Disposable parentDisposable) {
        super((LayoutManager)new WrapLayout(3, 0, 0));
        this.add(Box.createVerticalStrut(35));
        JPanel panel2 = new JPanel(new FlowLayout(1, 0, 0));
        this.myDropFirst.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        panel2.add(this.myDropFirst);
        panel2.setPreferredSize(this.myDropFirst.getPreferredSize());
        this.add(panel2);
        this.myDropFirst.setVisible(false);
        JBEmptyBorder border = JBUI.Borders.empty((int)5, (int)0, (int)0, (int)5);
        this.myAddButton = new InplaceButton(ExecutionBundle.message((String)"run.configuration.before.run.add.task", (Object[])new Object[0]), AllIcons.General.Add, e -> this.showPopup());
        this.myAddPanel = new JPanel();
        this.myAddPanel.setBorder((Border)border);
        this.myAddPanel.add((Component)this.myAddButton);
        this.myAddLabel = new LinkLabel(ExecutionBundle.message((String)"run.configuration.before.run.add.task", (Object[])new Object[0]), null, (aSource, aLinkData) -> this.showPopup());
        this.myAddLabel.setBorder((Border)border);
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)this, parentDisposable);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (BeforeRunComponent.this.myTags != null) {
                    BeforeRunComponent.this.myTags.forEach(Disposer::dispose);
                    BeforeRunComponent.this.myTags = null;
                }
            }
        });
    }

    private List<BeforeRunTaskProvider<BeforeRunTask<?>>> getProviders() {
        return ContainerUtil.filter((Collection)BeforeRunTaskProvider.EP_NAME.getExtensions((AreaInstance)this.myConfiguration.getProject()), provider -> provider.createTask(this.myConfiguration) != null);
    }

    private void createTags() {
        this.myTags = new ArrayList<TaskButton>();
        for (BeforeRunTaskProvider<BeforeRunTask<?>> provider : this.getProviders()) {
            this.myTags.add(new TaskButton(provider, () -> {
                this.myChangeListener.run();
                this.updateAddLabel();
                this.myTagListener.accept(provider.getId(), false);
            }));
        }
    }

    private void updateAddLabel() {
        this.myAddLabel.setVisible(this.getEnabledTasks().isEmpty());
    }

    public void showPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        for (BeforeRunTaskProvider<BeforeRunTask<?>> provider : this.getProviders()) {
            final TaskButton tag2 = (TaskButton)((Object)ContainerUtil.find(this.myTags, t -> ((TaskButton)t).myProvider.getId() == provider.getId()));
            if (tag2.isVisible()) continue;
            group.add(new AnAction(tag2.myProvider.getName(), null, tag2.myProvider.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BeforeRunComponent.this.createTask(e, tag2);
                }
            });
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)this.myAddButton), false, false, false, null, -1, Conditions.alwaysTrue());
        popup2.showUnderneathOf((Component)this.myAddButton);
    }

    public void addOrRemove(Key<? extends BeforeRunTask<?>> providerId, boolean add2) {
        if (this.myTags == null) {
            return;
        }
        TaskButton taskButton = (TaskButton)((Object)ContainerUtil.find(this.myTags, button2 -> ((TaskButton)button2).myProvider.getId() == providerId));
        if (add2) {
            if (!taskButton.isVisible()) {
                this.createTask(null, taskButton);
            }
        } else {
            taskButton.setVisible(false);
        }
    }

    private void createTask(@Nullable AnActionEvent e, TaskButton tag2) {
        BeforeRunTask task2 = tag2.myProvider.createTask(this.myConfiguration);
        if (task2 == null) {
            return;
        }
        if (e == null) {
            this.addTask(tag2, task2);
            return;
        }
        tag2.myProvider.configureTask(e.getDataContext(), this.myConfiguration, task2).onSuccess(changed2 -> {
            if (!tag2.myProvider.canExecuteTask(this.myConfiguration, task2)) {
                return;
            }
            this.addTask(tag2, task2);
        });
    }

    private void addTask(TaskButton tag2, BeforeRunTask<?> task2) {
        task2.setEnabled(true);
        tag2.setTask(task2);
        this.myTags.remove((Object)tag2);
        this.myTags.add(tag2);
        this.buildPanel();
        this.myChangeListener.run();
        this.myTagListener.accept(tag2.myProvider.getId(), true);
    }

    public void reset(@NotNull RunnerAndConfigurationSettingsImpl s) {
        this.myConfiguration = s.getConfiguration();
        if (this.myTags == null) {
            this.createTags();
        }
        List<BeforeRunTask<?>> tasks = s.getManager().getBeforeRunTasks(s.getConfiguration());
        for (BeforeRunTask<?> task2 : tasks) {
            TaskButton button2 = (TaskButton)((Object)ContainerUtil.find(this.myTags, tag2 -> ((TaskButton)tag2).myProvider.getId() == task2.getProviderId()));
            if (button2 == null) continue;
            button2.setTask(task2);
            this.myTags.remove((Object)button2);
            this.myTags.add(button2);
        }
        this.buildPanel();
    }

    private void buildPanel() {
        this.remove(this.myAddPanel);
        this.remove((Component)this.myAddLabel);
        for (TaskButton tag2 : this.myTags) {
            this.remove((Component)((Object)tag2));
        }
        for (TaskButton tag2 : this.myTags) {
            if (!tag2.isVisible()) continue;
            this.add((Component)((Object)tag2));
        }
        this.add(this.myAddPanel);
        this.add((Component)this.myAddLabel);
        this.updateAddLabel();
    }

    public void apply(RunnerAndConfigurationSettingsImpl s) {
        s.getManager().setBeforeRunTasks(s.getConfiguration(), (List<? extends BeforeRunTask<?>>)this.getEnabledTasks());
    }

    @NotNull
    private List<BeforeRunTask<?>> getEnabledTasks() {
        return this.myTags.stream().filter(button2 -> ((TaskButton)button2).myTask != null && button2.isVisible()).map(button2 -> ((TaskButton)button2).myTask).collect(Collectors.toList());
    }

    public void drop(DnDEvent event) {
        TagButton replaceButton = this.getReplaceButton(event);
        if (replaceButton == null) {
            return;
        }
        TaskButton button2 = (TaskButton)((Object)event.getAttachedObject());
        int i2 = this.myTags.indexOf(replaceButton);
        this.myTags.remove((Object)button2);
        this.myTags.add(i2, button2);
        this.buildPanel();
        this.myChangeListener.run();
        IdeFocusManager.getInstance((Project)this.myConfiguration.getProject()).requestFocus((Component)((Object)button2), false);
    }

    public void cleanUpOnLeave() {
        if (this.myTags != null) {
            this.myTags.forEach(button2 -> ((TaskButton)button2).showDropPlace(false));
        }
        this.myDropFirst.setVisible(false);
    }

    private TagButton getReplaceButton(DnDEvent event) {
        Object object = event.getAttachedObject();
        if (!(object instanceof TaskButton)) {
            return null;
        }
        Rectangle area = new Rectangle(event.getPoint().x - 5, event.getPoint().y - 5, 10, 10);
        TaskButton button2 = (TaskButton)((Object)ContainerUtil.find(this.myTags, tag2 -> tag2.isVisible() && tag2.getBounds().intersects(area)));
        if (button2 == null || button2 == object) {
            return null;
        }
        boolean left = button2.getBounds().getCenterX() > (double)event.getPoint().x;
        int i2 = this.myTags.indexOf((Object)button2);
        if (i2 < this.myTags.indexOf(object)) {
            if (!left) {
                button2 = (TaskButton)((Object)ContainerUtil.find(this.myTags, b -> b.isVisible() && this.myTags.indexOf(b) > i2));
            }
        } else if (left) {
            button2 = (TaskButton)((Object)ContainerUtil.findLast(this.myTags, b -> b.isVisible() && this.myTags.indexOf(b) < i2));
        }
        return button2 == object ? null : button2;
    }

    private TagButton getDropButton(TagButton replaceButton, DnDEvent event) {
        int i2 = this.myTags.indexOf(replaceButton);
        if (i2 > this.myTags.indexOf(event.getAttachedObject())) {
            return replaceButton;
        }
        return (TagButton)ContainerUtil.findLast(this.myTags, button2 -> button2.isVisible() && this.myTags.indexOf(button2) < i2);
    }

    public boolean update(DnDEvent event) {
        TagButton replace = this.getReplaceButton(event);
        if (replace != null) {
            TagButton dropButton = this.getDropButton(replace, event);
            this.myTags.forEach(button2 -> ((TaskButton)button2).showDropPlace(button2 == dropButton));
            this.myDropFirst.setVisible(dropButton == null);
            event.setDropPossible(true);
            return false;
        }
        this.myTags.forEach(button2 -> ((TaskButton)button2).showDropPlace(false));
        event.setDropPossible(false);
        return true;
    }

    public void setTagListener(BiConsumer<Key<? extends BeforeRunTask<?>>, Boolean> tagListener) {
        this.myTagListener = tagListener;
    }

    private class TaskButton
    extends TagButton
    implements DnDSource {
        private final BeforeRunTaskProvider<BeforeRunTask<?>> myProvider;
        private final JLabel myDropPlace;
        private BeforeRunTask<?> myTask;

        private TaskButton(@NotNull BeforeRunTaskProvider<BeforeRunTask<?>> provider, Runnable action2) {
            super(provider.getName(), action2);
            this.myDropPlace = new JLabel(AllIcons.General.DropPlace);
            this.add(this.myDropPlace, JLayeredPane.DRAG_LAYER);
            this.myProvider = provider;
            this.setVisible(false);
            this.myDropPlace.setVisible(false);
            this.myButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TaskButton.this.myProvider.configureTask(DataManager.getInstance().getDataContext((Component)((Object)TaskButton.this)), BeforeRunComponent.this.myConfiguration, TaskButton.this.myTask).onSuccess(aBoolean -> TaskButton.this.setTask(TaskButton.this.myTask));
                    }
                }
            });
            DnDManager.getInstance().registerSource((DnDSource)this, (JComponent)this.myButton, (Disposable)this);
            this.myButton.setToolTipText(ExecutionBundle.message((String)"run.configuration.before.run.tooltip", (Object[])new Object[0]));
            this.layoutButtons();
        }

        protected void layoutButtons() {
            super.layoutButtons();
            if (this.myDropPlace == null) {
                return;
            }
            Rectangle bounds2 = this.myButton.getBounds();
            Dimension size = this.myDropPlace.getPreferredSize();
            this.myDropPlace.setBounds(bounds2.x + bounds2.width + 2, bounds2.y + (bounds2.height - size.height) / 2, size.width, size.height);
        }

        private void setTask(@Nullable BeforeRunTask<?> task2) {
            this.myTask = task2;
            this.setVisible(task2 != null);
            if (task2 != null) {
                this.updateButton(this.myProvider.getDescription(task2), this.myProvider.getTaskIcon(task2));
            }
        }

        private void showDropPlace(boolean show2) {
            this.myDropPlace.setVisible(show2);
        }

        public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
            return true;
        }

        public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
            return new DnDDragStartBean((Object)this);
        }

        public String toString() {
            return this.myProvider.getName();
        }
    }
}

