/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMPoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestsPresentationUtil {
    @NonNls
    private static final String DOUBLE_SPACE = "  ";
    @NonNls
    private static final String UNKNOWN_TESTS_COUNT = "<...>";
    @NonNls
    static final String DEFAULT_TESTS_CATEGORY = "Tests";

    private TestsPresentationUtil() {
    }

    public static String getProgressStatus_Text(long startTime, long endTime, int testsTotal, int testsCount, int failuresCount, @Nullable Set<String> allCategories, boolean isFinished) {
        StringBuilder sb = new StringBuilder();
        if (endTime == 0L) {
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running", new Object[0]));
        } else {
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.done", new Object[0]));
        }
        if (allCategories != null && TestsPresentationUtil.hasNonDefaultCategories(allCategories)) {
            sb.append(' ');
            boolean first = true;
            for (String category : allCategories) {
                if (StringUtil.isEmpty((String)category)) continue;
                if (!first) {
                    sb.append(", ");
                }
                char firstChar = category.charAt(0);
                sb.append(first ? firstChar : Character.toLowerCase(firstChar));
                sb.append(category.substring(1));
                first = false;
            }
        }
        sb.append(' ').append(testsCount).append(' ');
        sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.of", new Object[0]));
        sb.append(' ').append(testsTotal != 0 ? Integer.valueOf(testsTotal) : (!isFinished ? UNKNOWN_TESTS_COUNT : Integer.valueOf(0)));
        if (failuresCount > 0) {
            sb.append(DOUBLE_SPACE);
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.failed", new Object[0]));
            sb.append(' ').append(failuresCount);
        }
        if (endTime != 0L) {
            long time = endTime - startTime;
            sb.append(DOUBLE_SPACE);
            sb.append('(').append(StringUtil.formatDuration((long)time, (String)"\u2009")).append(')');
        }
        sb.append(DOUBLE_SPACE);
        return sb.toString();
    }

    public static boolean hasNonDefaultCategories(@Nullable Set<String> allCategories) {
        if (allCategories == null) {
            return false;
        }
        return allCategories.size() > 1 || allCategories.size() == 1 && !DEFAULT_TESTS_CATEGORY.equals(allCategories.iterator().next());
    }

    public static void formatRootNodeWithChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
        renderer.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        String presentableName = testProxy.getPresentation();
        String text = presentableName != null ? presentableName : (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running.tests", new Object[0]) : (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]) : SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.results", new Object[0])));
        renderer.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = testProxy.getComment();
        if (comment != null) {
            renderer.append(" (" + comment + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void formatRootNodeWithoutChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
            if (!testProxy.getChildren().isEmpty()) {
                TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
            } else {
                renderer.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
                renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.instantiating.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else if (magnitude == TestStateInfo.Magnitude.NOT_RUN_INDEX) {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.not.test.results", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.PASSED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.PASSED_ICON);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.tests.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.IGNORED_INDEX && !testProxy.hasErrors()) {
            renderer.setIcon(PoolOfTestIcons.IGNORED_ICON);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.but.ignored.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (!testProxy.getChildren().isEmpty()) {
            TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
        } else {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(testProxy.isTestsReporterAttached() ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]) : SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void formatTestProxy(SMTestProxy testProxy, TestTreeRenderer renderer) {
        renderer.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        renderer.append(testProxy.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public static String getPresentableName(SMTestProxy testProxy) {
        String parentName;
        SMTestProxy parent = testProxy.getParent();
        String name = testProxy.getName();
        if (name == null) {
            return Holder.getNoNameTest();
        }
        String presentationCandidate = name;
        if (parent != null && !testProxy.isSuite() && (parentName = parent.getName()) != null) {
            String comment;
            String presentation2;
            boolean parentStartsWith = name.startsWith(parentName);
            if (!parentStartsWith && parent instanceof SMTestProxy.SMRootTestProxy && (presentation2 = ((SMTestProxy.SMRootTestProxy)parent).getPresentation()) != null && !(parentStartsWith = name.startsWith(parentName = presentation2)) && (comment = ((SMTestProxy.SMRootTestProxy)parent).getComment()) != null) {
                parentName = StringUtil.getQualifiedName((String)comment, (String)presentation2);
                parentStartsWith = name.startsWith(parentName);
            }
            if (parentStartsWith) {
                presentationCandidate = name.substring(parentName.length());
                presentationCandidate = StringUtil.trimStart((String)presentationCandidate, (String)".");
            }
        }
        presentationCandidate = presentationCandidate.trim();
        if (StringUtil.isEmpty((String)(presentationCandidate = presentationCandidate.replaceAll("\\s+", " ")))) {
            return Holder.getNoNameTest();
        }
        return presentationCandidate;
    }

    @NotNull
    public static String getPresentableNameTrimmedOnly(@NotNull SMTestProxy testProxy) {
        String name = testProxy.getName();
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            name = Holder.getNoNameTest();
        }
        return name;
    }

    @Nullable
    private static Icon getIcon(SMTestProxy testProxy, TestConsoleProperties consoleProperties) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        boolean hasErrors = testProxy.hasErrors();
        switch (magnitude) {
            case ERROR_INDEX: {
                return SMPoolOfTestIcons.ERROR_ICON;
            }
            case FAILED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.FAILED_E_ICON : SMPoolOfTestIcons.FAILED_ICON;
            }
            case IGNORED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.IGNORED_E_ICON : SMPoolOfTestIcons.IGNORED_ICON;
            }
            case NOT_RUN_INDEX: {
                return SMPoolOfTestIcons.NOT_RAN;
            }
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.PASSED_E_ICON : SMPoolOfTestIcons.PASSED_ICON;
            }
            case RUNNING_INDEX: {
                if (consoleProperties.isPaused()) {
                    return hasErrors ? SMPoolOfTestIcons.PAUSED_E_ICON : AllIcons.RunConfigurations.TestPaused;
                }
                return hasErrors ? SMPoolOfTestIcons.RUNNING_E_ICON : SMPoolOfTestIcons.RUNNING_ICON;
            }
            case SKIPPED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.SKIPPED_E_ICON : SMPoolOfTestIcons.SKIPPED_ICON;
            }
            case TERMINATED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.TERMINATED_E_ICON : SMPoolOfTestIcons.TERMINATED_ICON;
            }
        }
        return null;
    }

    @Nullable
    public static String getTestStatusPresentation(SMTestProxy proxy) {
        return proxy.getMagnitudeInfo().getTitle();
    }

    private static class Holder {
        private Holder() {
        }

        private static String getNoNameTest() {
            return SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.noname", new Object[0]);
        }
    }
}

