/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.execution.testframework.autotest.DelayedDocumentWatcher;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

@State(name="AutoTestManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class AutoTestManager
extends AbstractAutoTestManager {
    @NotNull
    public static AutoTestManager getInstance(Project project) {
        return (AutoTestManager)project.getService(AutoTestManager.class);
    }

    public AutoTestManager(@NotNull Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected AutoTestWatcher createWatcher(@NotNull Project project) {
        return new DelayedDocumentWatcher(project, this.myDelayMillis, this::restartAllAutoTests, file2 -> {
            if (ScratchUtil.isScratch(file2)) {
                return false;
            }
            return FileEditorManager.getInstance((Project)project).isFileOpen(file2);
        });
    }
}

