/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.ide.navigationToolbar.NavBarBorder;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceViewTreeUi
implements ServiceViewUi {
    private final JPanel myMainPanel;
    private final SimpleToolWindowPanel myContentPanel = new SimpleToolWindowPanel(false);
    private final Splitter mySplitter;
    private final JPanel myMasterPanel;
    private final JPanel myDetailsPanel;
    private final JPanel myNavBarPanel;
    private final JBPanelWithEmptyText myMessagePanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"service.view.empty.selection.text", (Object[])new Object[0]));
    private final Set<JComponent> myDetailsComponents = ContainerUtil.createWeakSet();
    private ActionToolbar myServiceActionToolbar;
    private ActionToolbar myMasterActionToolbar;

    ServiceViewTreeUi(@NotNull ServiceViewState state) {
        this.myMainPanel = new SimpleToolWindowPanel(false);
        this.myNavBarPanel = new JPanel(new BorderLayout());
        this.myNavBarPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myMainPanel.add((Component)this.myNavBarPanel, "North");
        this.mySplitter = new OnePixelSplitter(false, state.contentProportion);
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myContentPanel.setContent((JComponent)this.mySplitter);
        this.myMasterPanel = new JPanel(new BorderLayout());
        this.mySplitter.setFirstComponent((JComponent)this.myMasterPanel);
        this.myDetailsPanel = new JPanel(new BorderLayout());
        this.myMessagePanel.setFocusable(true);
        this.myDetailsPanel.add((Component)this.myMessagePanel, "Center");
        this.mySplitter.setSecondComponent((JComponent)this.myDetailsPanel);
        if (state.showServicesTree) {
            this.myNavBarPanel.setVisible(false);
        } else {
            this.myMasterPanel.setVisible(false);
        }
        ComponentUtil.putClientProperty((JComponent)this.myMainPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from(this.myDetailsComponents).append((Object)this.myMessagePanel).filter(component2 -> this.myDetailsPanel != component2.getParent()).iterator());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myMainPanel;
    }

    @Override
    public void saveState(@NotNull ServiceViewState state) {
        state.contentProportion = this.mySplitter.getProportion();
    }

    @Override
    public void setServiceToolbar(@NotNull ServiceViewActionProvider actionProvider) {
        this.myServiceActionToolbar = actionProvider.createServiceToolbar(this.myMainPanel);
        this.myContentPanel.setToolbar(actionProvider.wrapServiceToolbar(this.myServiceActionToolbar));
    }

    @Override
    public void setMasterComponent(@NotNull JComponent component2, @NotNull ServiceViewActionProvider actionProvider) {
        this.myMasterPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)component2, (int)2), "Center");
        this.myMasterActionToolbar = actionProvider.createMasterComponentToolbar(component2);
        JComponent toolbarComponent = this.myMasterActionToolbar.getComponent();
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)1, (int)0, (int)2, (int)0));
        this.myMasterPanel.add((Component)toolbarComponent, "North");
        actionProvider.installPopupHandler(component2);
    }

    @Override
    public void setNavBar(@NotNull JComponent component2) {
        final JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component2);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setHorizontalScrollBar(null);
        scrollPane.setBorder(new NavBarBorder());
        JPanel navBarPanelWrapper = new JPanel(new BorderLayout()){

            @Override
            public void doLayout() {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                int x = insets.left;
                Dimension preferredSize = scrollPane.getPreferredSize();
                scrollPane.setBounds(x, (r.height - preferredSize.height) / 2, r.width - insets.left - insets.right, preferredSize.height);
            }
        };
        navBarPanelWrapper.add((Component)scrollPane, "Center");
        this.myNavBarPanel.add((Component)navBarPanelWrapper, "Center");
    }

    @Override
    public void setMasterComponentVisible(boolean visible) {
        this.myMasterPanel.setVisible(visible);
        this.myNavBarPanel.setVisible(!visible);
    }

    @Override
    public void setDetailsComponent(@Nullable JComponent component2) {
        ActionToolbar masterActionToolbar;
        if (component2 == null) {
            component2 = this.myMessagePanel;
        }
        if (component2.getParent() == this.myDetailsPanel) {
            return;
        }
        this.myDetailsComponents.add(component2);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)component2, "Center");
        this.myDetailsPanel.revalidate();
        this.myDetailsPanel.repaint();
        ActionToolbar serviceActionToolbar = this.myServiceActionToolbar;
        if (serviceActionToolbar != null) {
            serviceActionToolbar.updateActionsImmediately();
        }
        if ((masterActionToolbar = this.myMasterActionToolbar) != null) {
            masterActionToolbar.updateActionsImmediately();
        }
    }

    @Override
    @Nullable
    public JComponent getDetailsComponent() {
        int count = this.myDetailsPanel.getComponentCount();
        if (count == 0) {
            return null;
        }
        Component component2 = this.myDetailsPanel.getComponent(0);
        return component2 == this.myMessagePanel ? null : (JComponent)component2;
    }
}

