/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.util.PlatformUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class ServiceViewSourceScrollHelper {
    private static final String AUTO_SCROLL_TO_SOURCE_PROPERTY = "service.view.auto.scroll.to.source";
    private static final String AUTO_SCROLL_FROM_SOURCE_PROPERTY = "service.view.auto.scroll.from.source";

    ServiceViewSourceScrollHelper() {
    }

    @NotNull
    static AutoScrollToSourceHandler createAutoScrollToSourceHandler(@NotNull Project project) {
        return new ServiceViewAutoScrollToSourceHandler(project);
    }

    static void installAutoScrollSupport(@NotNull Project project, @NotNull ToolWindowEx toolWindow, @NotNull AutoScrollToSourceHandler toSourceHandler) {
        ServiceViewAutoScrollFromSourceHandler fromSourceHandler = new ServiceViewAutoScrollFromSourceHandler(project, toolWindow);
        fromSourceHandler.install();
        DefaultActionGroup additionalGearActions = new DefaultActionGroup(new AnAction[]{toSourceHandler.createToggleAction(), fromSourceHandler.createToggleAction(), Separator.getInstance()});
        List<AnAction> additionalProviderActions = ServiceViewActionProvider.getInstance().getAdditionalGearActions();
        for (AnAction action2 : additionalProviderActions) {
            additionalGearActions.add(action2);
        }
        toolWindow.setAdditionalGearActions((ActionGroup)additionalGearActions);
        toolWindow.setTitleActions(new AnAction[]{new ScrollFromEditorAction(fromSourceHandler)});
    }

    private static boolean isAutoScrollFromSourceEnabled(@NotNull Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(AUTO_SCROLL_FROM_SOURCE_PROPERTY, PlatformUtils.isDataGrip());
    }

    private static class ScrollFromEditorAction
    extends DumbAwareAction {
        private final ServiceViewAutoScrollFromSourceHandler myScrollFromHandler;

        ScrollFromEditorAction(ServiceViewAutoScrollFromSourceHandler scrollFromHandler) {
            super(ExecutionBundle.message((String)"service.view.scroll.from.editor.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"service.view.scroll.from.editor.action.description", (Object[])new Object[0]), AllIcons.General.Locate);
            this.myScrollFromHandler = scrollFromHandler;
        }

        public void update(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(!ServiceViewSourceScrollHelper.isAutoScrollFromSourceEnabled(project));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor[] editors = manager.getSelectedEditors();
            this.select(Arrays.asList(editors).iterator());
        }

        private void select(Iterator<FileEditor> editors) {
            if (!editors.hasNext()) {
                return;
            }
            FileEditor editor = editors.next();
            this.myScrollFromHandler.select(editor).onError(r -> this.select(editors));
        }
    }

    private static class ServiceViewAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        ServiceViewAutoScrollFromSourceHandler(@NotNull Project project, @NotNull ToolWindow toolWindow) {
            super(project, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
        }

        protected boolean isAutoScrollEnabled() {
            return ServiceViewSourceScrollHelper.isAutoScrollFromSourceEnabled(this.myProject);
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(ServiceViewSourceScrollHelper.AUTO_SCROLL_FROM_SOURCE_PROPERTY, enabled, PlatformUtils.isDataGrip());
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            this.select(editor);
        }

        private Promise<Void> select(@NotNull FileEditor editor) {
            VirtualFile virtualFile = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(editor);
            if (virtualFile == null) {
                return Promises.rejectedPromise((String)"Virtual file is null");
            }
            return ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)this.myProject)).select(virtualFile);
        }
    }

    private static class ServiceViewAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        private final Project myProject;

        ServiceViewAutoScrollToSourceHandler(@NotNull Project project) {
            this.myProject = project;
        }

        protected boolean isAutoScrollMode() {
            return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(ServiceViewSourceScrollHelper.AUTO_SCROLL_TO_SOURCE_PROPERTY);
        }

        protected void setAutoScrollMode(boolean state) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(ServiceViewSourceScrollHelper.AUTO_SCROLL_TO_SOURCE_PROPERTY, state);
        }
    }
}

