/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ServiceViewDeleteProvider
implements DeleteProvider {
    private final ServiceView myServiceView;

    ServiceViewDeleteProvider(@NotNull ServiceView serviceView) {
        this.myServiceView = serviceView;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        List<Pair<ServiceModel.ServiceViewItem, Runnable>> items = ContainerUtil.mapNotNull(this.myServiceView.getSelectedItems(), item -> {
            Runnable remover = item.getViewDescriptor().getRemover();
            return remover == null ? null : Pair.create((Object)item, (Object)remover);
        });
        if ((items = ServiceViewDeleteProvider.filterChildren(items)).isEmpty()) {
            return;
        }
        if (Messages.showYesNoDialog((Project)project, (String)ExecutionBundle.message((String)"service.view.delete.confirmation", (Object[])new Object[]{ExecutionBundle.message((String)"service.view.items", (Object[])new Object[]{items.size()})}), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        for (Pair<ServiceModel.ServiceViewItem, Runnable> item2 : items) {
            ((Runnable)item2.second).run();
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (this.myServiceView.getSelectedItems().stream().noneMatch(item -> item.getViewDescriptor().getRemover() != null)) {
            return false;
        }
        JComponent detailsComponent = this.myServiceView.getUi().getDetailsComponent();
        return detailsComponent == null || !UIUtil.isAncestor((Component)detailsComponent, (Component)((Component)dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT)));
    }

    @NotNull
    private static List<Pair<ServiceModel.ServiceViewItem, Runnable>> filterChildren(List<Pair<ServiceModel.ServiceViewItem, Runnable>> items) {
        return ContainerUtil.filter(items, item -> {
            for (ServiceModel.ServiceViewItem parent = ((ServiceModel.ServiceViewItem)item.first).getParent(); parent != null; parent = parent.getParent()) {
                for (Pair pair : items) {
                    if (!((ServiceModel.ServiceViewItem)pair.first).equals(parent)) continue;
                    return false;
                }
            }
            return true;
        });
    }
}

