/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunContentBuilder
extends RunTab {
    private static final String JAVA_RUNNER = "JavaRunner";
    private final List<AnAction> myRunnerActions = new SmartList();
    private final ExecutionResult myExecutionResult;

    public RunContentBuilder(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        super(environment, RunContentBuilder.getRunnerType(executionResult.getExecutionConsole()));
        this.myExecutionResult = executionResult;
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
    }

    @NotNull
    public static ExecutionEnvironment fix(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner runner) {
        if (runner == null || runner.equals(environment.getRunner())) {
            return environment;
        }
        return new ExecutionEnvironmentBuilder(environment).runner(runner).build();
    }

    public void addAction(@NotNull AnAction action2) {
        this.myRunnerActions.add(action2);
    }

    @NotNull
    private RunContentDescriptor createDescriptor() {
        RunProfile profile = this.myEnvironment.getRunProfile();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new RunContentDescriptor(profile, this.myExecutionResult, this.myUi);
        }
        ExecutionConsole console = this.myExecutionResult.getExecutionConsole();
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(profile, this.myExecutionResult, this.myUi);
        AnAction[] consoleActionsToMerge = AnAction.EMPTY_ARRAY;
        Content consoleContent = null;
        if (console != null) {
            if (console instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console).buildUi(this.myUi);
            } else {
                consoleContent = RunContentBuilder.buildConsoleUiDefault(this.myUi, console);
            }
            this.initLogConsoles(profile, contentDescriptor, console);
        }
        if (consoleContent != null && this.myUi.getContentManager().getContentCount() == 1 && console instanceof TerminalExecutionConsole) {
            consoleActionsToMerge = ((TerminalExecutionConsole)console).createConsoleActions();
            consoleContent.setActions((ActionGroup)new DefaultActionGroup(), "RunnerToolbar", console.getComponent());
        }
        this.myUi.getOptions().setLeftToolbar(this.createActionToolbar(contentDescriptor, consoleActionsToMerge), "RunnerToolbar");
        if (profile instanceof RunConfigurationBase && console instanceof ObservableConsoleView && !ApplicationManager.getApplication().isUnitTestMode()) {
            ((ObservableConsoleView)console).addChangeListener((ObservableConsoleView.ChangeListener)new ConsoleToFrontListener((RunConfigurationBase)profile, this.myProject, this.myEnvironment.getExecutor(), contentDescriptor, this.myUi), (Disposable)this);
        }
        return contentDescriptor;
    }

    @NotNull
    private static String getRunnerType(@Nullable ExecutionConsole console) {
        String id2;
        if (console instanceof ExecutionConsoleEx && (id2 = ((ExecutionConsoleEx)console).getExecutionConsoleId()) != null) {
            return "JavaRunner." + id2;
        }
        return JAVA_RUNNER;
    }

    @NotNull
    public static Content buildConsoleUiDefault(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
        Content consoleContent = ui.createContent("ConsoleContent", console.getComponent(), CommonBundle.message((String)"title.console", (Object[])new Object[0]), AllIcons.Debugger.Console, console.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions(console, consoleContent);
        ui.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
        return consoleContent;
    }

    public static void addAdditionalConsoleEditorActions(ExecutionConsole console, Content consoleContent) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console instanceof ConsoleView) {
            for (AnAction action2 : ((ConsoleView)console).createConsoleActions()) {
                consoleActions.add(action2);
            }
        }
        consoleContent.setActions((ActionGroup)consoleActions, "RunnerToolbar", console.getComponent());
    }

    @NotNull
    private ActionGroup createActionToolbar(@NotNull RunContentDescriptor contentDescriptor, AnAction @NotNull [] consoleActions) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("Rerun"));
        AnAction[] actions = contentDescriptor.getRestartActions();
        actionGroup.addAll(actions);
        if (actions.length > 0) {
            actionGroup.addSeparator();
        }
        actionGroup.add(ActionManager.getInstance().getAction("Stop"));
        actionGroup.addAll(this.myExecutionResult.getActions());
        if (consoleActions.length > 0) {
            actionGroup.addSeparator();
            actionGroup.addAll(consoleActions);
        }
        for (AnAction anAction : this.myRunnerActions) {
            if (anAction != null) {
                actionGroup.add(anAction);
                continue;
            }
            actionGroup.addSeparator();
        }
        actionGroup.addSeparator();
        actionGroup.add(this.myUi.getOptions().getLayoutActions());
        actionGroup.addSeparator();
        actionGroup.add(PinToolwindowTabAction.getPinAction());
        return actionGroup;
    }

    public RunContentDescriptor showRunContent(@Nullable RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor2 = this.createDescriptor();
        Disposer.register((Disposable)descriptor2, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)descriptor2);
        RunContentManagerImpl.copyContentAndBehavior(descriptor2, reuseContent);
        this.myRunContentDescriptor = descriptor2;
        return descriptor2;
    }

    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    public static final class ConsoleToFrontListener
    implements ObservableConsoleView.ChangeListener {
        @NotNull
        private final RunConfigurationBase myRunConfigurationBase;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Executor myExecutor;
        @NotNull
        private final RunContentDescriptor myRunContentDescriptor;
        @NotNull
        private final RunnerLayoutUi myUi;

        public ConsoleToFrontListener(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor, @NotNull RunnerLayoutUi ui) {
            this.myRunConfigurationBase = runConfigurationBase;
            this.myProject = project;
            this.myExecutor = executor;
            this.myRunContentDescriptor = runContentDescriptor;
            this.myUi = ui;
        }

        public void contentAdded(@NotNull Collection<ConsoleViewContentType> types) {
            if (this.myProject.isDisposed() || this.myUi.isDisposed()) {
                return;
            }
            for (ConsoleViewContentType type : types) {
                if ((type != ConsoleViewContentType.NORMAL_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdOut()) && (type != ConsoleViewContentType.ERROR_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdErr())) continue;
                RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myExecutor, this.myRunContentDescriptor);
                this.myUi.selectAndFocus(this.myUi.findContent("ConsoleContent"), false, false);
                return;
            }
        }
    }
}

