/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableColoredProcessHandler
extends ColoredProcessHandler
implements KillableProcess {
    public KillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        this(commandLine, false);
    }

    public KillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        super(KillableColoredProcessHandler.mediate(commandLine, withMediator, false));
        this.setShouldKillProcessSoftly(true);
    }

    public KillableColoredProcessHandler(@NotNull Process process2, String commandLine) {
        super(process2, commandLine);
        this.setShouldKillProcessSoftly(true);
    }

    public KillableColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        this(process2, commandLine, charset, null);
    }

    public KillableColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset, @Nullable Set<? extends File> filesToDelete) {
        super(process2, commandLine, charset, filesToDelete);
        this.setShouldKillProcessSoftly(true);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static KillableColoredProcessHandler create(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new KillableColoredProcessHandler(commandLine, true);
    }

    public static class Silent
    extends KillableColoredProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            super(commandLine);
        }

        public Silent(@NotNull Process process2, String commandLine, @NotNull Charset charset, @Nullable Set<? extends File> filesToDetele) {
            super(process2, commandLine, charset, filesToDetele);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return BaseOutputReader.Options.forMostlySilentProcess();
        }
    }
}

