/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredProcessHandler
extends KillableProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

    public ColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine) {
        super(process2, commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        this(process2, commandLine, charset, null);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset, @Nullable Set<? extends File> filesToDelete) {
        super(process2, commandLine, charset, filesToDelete);
        this.setShouldKillProcessSoftly(false);
    }

    public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected void notifyColoredListeners(String text, Key attributes) {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public void addColoredTextListener(final AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                listener2.coloredTextAvailable(event.getText(), outputType);
            }
        });
    }
}

