/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunLineMarkerContributor {
    public static final java.util.function.Function<PsiElement, String> RUN_TEST_TOOLTIP_PROVIDER = it -> "Run Test";
    static final LanguageExtension<RunLineMarkerContributor> EXTENSION = new LanguageExtension("com.intellij.runLineMarkerContributor");

    @NotNull
    public static Info withExecutorActions(@NotNull Icon icon2) {
        return new Info(icon2, ExecutorAction.getActions(1), RUN_TEST_TOOLTIP_PROVIDER);
    }

    @Nullable
    public abstract Info getInfo(@NotNull PsiElement var1);

    public boolean producesAllPossibleConfigurations(@NotNull PsiFile file2) {
        return true;
    }

    @Nullable(value="null means disabled")
    protected static @Nullable(value="null means disabled") String getText(@NotNull AnAction action2, @NotNull PsiElement element2) {
        DataContext parent = DataManager.getInstance().getDataContext();
        DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PSI_ELEMENT.getName(), element2, parent);
        if (!(action2 instanceof ExecutorAction)) {
            return null;
        }
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        action2.update(event);
        if (!event.getPresentation().isEnabledAndVisible()) {
            return null;
        }
        String name = ((ExecutorAction)action2).getActionName(dataContext);
        return name == null ? null : TextWithMnemonic.parse((String)name).getText();
    }

    @NotNull
    protected static Icon getTestStateIcon(String url, @NotNull Project project, boolean isClass) {
        return RunLineMarkerContributor.getTestStateIcon(TestStateStorage.getInstance(project).getState(url), isClass);
    }

    @NotNull
    protected static Icon getTestStateIcon(@Nullable TestStateStorage.Record state, boolean isClass) {
        TestStateInfo.Magnitude magnitude;
        if (state != null && (magnitude = TestIconMapper.getMagnitude((int)state.magnitude)) != null) {
            switch (magnitude) {
                case ERROR_INDEX: 
                case FAILED_INDEX: {
                    return AllIcons.RunConfigurations.TestState.Red2;
                }
                case PASSED_INDEX: 
                case COMPLETE_INDEX: {
                    return AllIcons.RunConfigurations.TestState.Green2;
                }
            }
        }
        return isClass ? AllIcons.RunConfigurations.TestState.Run_run : AllIcons.RunConfigurations.TestState.Run;
    }

    public static class Info {
        public final Icon icon;
        public final AnAction[] actions;
        public final java.util.function.Function<PsiElement, String> tooltipProvider;

        public Info(Icon icon2, AnAction @NotNull [] actions, @Nullable java.util.function.Function<PsiElement, String> tooltipProvider) {
            this.icon = icon2;
            this.actions = actions;
            this.tooltipProvider = tooltipProvider;
        }

        public Info(Icon icon2, @Nullable Function<PsiElement, String> tooltipProvider, AnAction ... actions) {
            this.icon = icon2;
            this.actions = actions;
            this.tooltipProvider = tooltipProvider == null ? null : it -> (String)tooltipProvider.fun(it);
        }

        public Info(@NotNull AnAction action2) {
            this(action2.getTemplatePresentation().getIcon(), new AnAction[]{action2}, (PsiElement element2) -> RunLineMarkerContributor.getText(action2, element2));
        }

        public boolean shouldReplace(@NotNull Info other) {
            return false;
        }
    }
}

