/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.NewRunConfigurationTreePopupFactory;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseTreePopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewRunConfigurationPopup {
    static final ConfigurationType HIDDEN_ITEMS_STUB = new ConfigurationType(){

        @NotNull
        public String getDisplayName() {
            return "";
        }

        @Nls
        public String getConfigurationTypeDescription() {
            return "";
        }

        public Icon getIcon() {
            return EmptyIcon.ICON_16;
        }

        @NotNull
        public String getId() {
            return "";
        }

        public ConfigurationFactory[] getConfigurationFactories() {
            return ConfigurationFactory.EMPTY_ARRAY;
        }
    };

    @NotNull
    public static JBPopup createAddPopup(@NotNull Project project, final @NotNull List<? extends ConfigurationType> typesToShow, final @NotNull String defaultText, final @NotNull Consumer<? super ConfigurationFactory> creator, final @Nullable ConfigurationType selectedConfigurationType, final @Nullable Runnable finalStep, boolean showTitle) {
        if (Registry.is((String)"run.configuration.use.tree.popup.to.add.new", (boolean)false)) {
            return NewRunConfigurationPopup.createAddTreePopup(project, creator, selectedConfigurationType, showTitle);
        }
        BaseListPopupStep<ConfigurationType> step = new BaseListPopupStep<ConfigurationType>(showTitle ? ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]) : null, typesToShow){

            @NotNull
            public String getTextFor(ConfigurationType type) {
                return type != HIDDEN_ITEMS_STUB ? type.getDisplayName() : defaultText;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(ConfigurationType type) {
                return type.getIcon();
            }

            public PopupStep<?> onChosen(ConfigurationType type, boolean finalChoice) {
                if (this.hasSubstep(type)) {
                    return this.getSupStep(type);
                }
                if (type == HIDDEN_ITEMS_STUB) {
                    return this.doFinalStep(finalStep);
                }
                ConfigurationFactory[] factories2 = type.getConfigurationFactories();
                if (factories2.length > 0) {
                    creator.consume((Object)factories2[0]);
                }
                return FINAL_CHOICE;
            }

            public int getDefaultOptionIndex() {
                return selectedConfigurationType != HIDDEN_ITEMS_STUB ? typesToShow.indexOf(selectedConfigurationType) : super.getDefaultOptionIndex();
            }

            private ListPopupStep<?> getSupStep(ConfigurationType type) {
                ConfigurationFactory[] factories2 = type.getConfigurationFactories();
                Arrays.sort(factories2, (factory1, factory2) -> factory1.getName().compareToIgnoreCase(factory2.getName()));
                return new BaseListPopupStep<ConfigurationFactory>(ExecutionBundle.message((String)"add.new.run.configuration.action.name", (Object[])new Object[]{type.getDisplayName()}), factories2){

                    @NotNull
                    public String getTextFor(ConfigurationFactory value2) {
                        return value2.getName();
                    }

                    public Icon getIconFor(ConfigurationFactory factory2) {
                        return factory2.getIcon();
                    }

                    public PopupStep<?> onChosen(ConfigurationFactory factory2, boolean finalChoice) {
                        creator.consume((Object)factory2);
                        return FINAL_CHOICE;
                    }
                };
            }

            public boolean hasSubstep(ConfigurationType type) {
                return type.getConfigurationFactories().length > 1;
            }
        };
        return new ListPopupImpl(project, (ListPopupStep)step, (BaseListPopupStep)step, project){
            final /* synthetic */ BaseListPopupStep val$step;
            final /* synthetic */ Project val$project;
            {
                this.val$step = baseListPopupStep;
                this.val$project = project;
                super(x0, x1);
            }

            @Override
            protected void onSpeedSearchPatternChanged() {
                List values2 = this.val$step.getValues();
                values2.clear();
                values2.addAll(RunConfigurable.Companion.configurationTypeSorted(this.val$project, false, ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()));
                this.getListModel().updateOriginalList();
                super.onSpeedSearchPatternChanged();
            }
        };
    }

    private static JBPopup createAddTreePopup(final @NotNull Project project, final @NotNull Consumer<? super ConfigurationFactory> creator, final @Nullable ConfigurationType selectedConfigurationType, boolean showTitle) {
        final NewRunConfigurationTreePopupFactory treePopupFactory = (NewRunConfigurationTreePopupFactory)ApplicationManager.getApplication().getService(NewRunConfigurationTreePopupFactory.class);
        treePopupFactory.initStructure(project);
        AbstractTreeStructure structure = new AbstractTreeStructure(){
            private final Map<NodeDescriptor<?>, NodeDescriptor<?>[]> myCache = new HashMap();

            @NotNull
            public Object getRootElement() {
                return treePopupFactory.getRootElement();
            }

            public NodeDescriptor<?> @NotNull [] getChildElements(@NotNull Object element2) {
                NodeDescriptor nodeDescriptor = (NodeDescriptor)element2;
                if (!this.myCache.containsKey(nodeDescriptor)) {
                    this.myCache.put(nodeDescriptor, treePopupFactory.createChildElements(project, nodeDescriptor));
                }
                return this.myCache.get(nodeDescriptor);
            }

            @Nullable
            public Object getParentElement(@NotNull Object element2) {
                return ((NodeDescriptor)element2).getParentDescriptor();
            }

            @NotNull
            public NodeDescriptor<?> createDescriptor(@NotNull Object element2, @Nullable NodeDescriptor parentDescriptor) {
                return treePopupFactory.createDescriptor(project, element2, parentDescriptor, 30);
            }

            public void commit() {
            }

            public boolean hasSomethingToCommit() {
                return false;
            }
        };
        final AtomicBoolean isAutoSelectionPassed = new AtomicBoolean(selectedConfigurationType == null);
        BaseTreePopupStep<Object> treePopupStep = new BaseTreePopupStep<Object>(project, showTitle ? ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]) : null, structure){

            public boolean isRootVisible() {
                return false;
            }

            public boolean isSelectable(Object node, Object userData) {
                if (!(userData instanceof NodeDescriptor)) {
                    return false;
                }
                if (this.getStructure().getChildElements(userData).length > 0) {
                    return false;
                }
                userData = ((NodeDescriptor)userData).getElement();
                return isAutoSelectionPassed.get() || userData == selectedConfigurationType;
            }

            public PopupStep<?> onChosen(Object selectedValue, boolean finalChoice) {
                ConfigurationFactory[] factories2;
                Object element2 = ((NodeDescriptor)selectedValue).getElement();
                if (element2 instanceof ConfigurationType && (factories2 = ((ConfigurationType)element2).getConfigurationFactories()).length == 1) {
                    creator.consume((Object)factories2[0]);
                    return FINAL_CHOICE;
                }
                if (element2 instanceof ConfigurationFactory) {
                    creator.consume((Object)((ConfigurationFactory)element2));
                    return FINAL_CHOICE;
                }
                return super.onChosen(selectedValue, finalChoice);
            }
        };
        final TreePopupImpl treePopup = new TreePopupImpl(project, null, (TreePopupStep)treePopupStep, null){

            @Override
            protected void afterShow() {
                super.afterShow();
                isAutoSelectionPassed.set(true);
                this.scrollToSelection();
            }

            @Override
            public boolean shouldBeShowing(Object value2) {
                NodeDescriptor parent = value2 instanceof NodeDescriptor ? ((NodeDescriptor)value2).getParentDescriptor() : null;
                return super.shouldBeShowing(value2) || parent != null && super.shouldBeShowing(parent);
            }
        };
        DumbAwareAction collapseAllAction = new DumbAwareAction(UIBundle.message((String)"tree.view.collapse.all.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                treePopup.collapseAll();
            }
        };
        final ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("popup", (ActionGroup)new DefaultActionGroup(new AnAction[]{collapseAllAction}), true);
        toolbar.setMiniMode(true);
        treePopup.getTitle().setButtonComponent(new ActiveComponent(){

            public void setActive(boolean active) {
            }

            @NotNull
            public JComponent getComponent() {
                return toolbar.getComponent();
            }
        }, (Border)JBUI.Borders.empty((int)2, (int)1, (int)0, (int)1));
        return treePopup;
    }
}

