/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleViewUtil {
    public static final Key<Boolean> EDITOR_IS_CONSOLE_HISTORY_VIEW = Key.create((String)"EDITOR_IS_CONSOLE_HISTORY_VIEW");
    private static final Key<Boolean> REPLACE_ACTION_ENABLED = Key.create((String)"REPLACE_ACTION_ENABLED");

    @NotNull
    public static EditorEx setupConsoleEditor(Project project, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)document);
        EditorEx editor = (EditorEx)editorFactory.createViewer(document, project, EditorKind.CONSOLE);
        ConsoleViewUtil.setupConsoleEditor(editor, foldingOutlineShown, lineMarkerAreaShown);
        return editor;
    }

    public static void setupConsoleEditor(@NotNull EditorEx editor, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setLineMarkerAreaShown(lineMarkerAreaShown);
            editorSettings.setIndentGuidesShown(false);
            editorSettings.setLineNumbersShown(false);
            editorSettings.setFoldingOutlineShown(foldingOutlineShown);
            editorSettings.setAdditionalPageAtBottom(false);
            editorSettings.setAdditionalColumnsCount(0);
            editorSettings.setAdditionalLinesCount(0);
            editorSettings.setRightMarginShown(false);
            editorSettings.setCaretRowShown(false);
            editorSettings.setShowingSpecialChars(false);
            editor.getGutterComponentEx().setPaintBackground(false);
            DelegateColorScheme scheme = ConsoleViewUtil.updateConsoleColorScheme(editor.getColorsScheme());
            if (UISettings.getInstance().getPresentationMode()) {
                scheme.setEditorFontSize(UISettings.getInstance().getPresentationModeFontSize());
            }
            editor.setColorsScheme(scheme);
            editor.setHighlighter(new NullEditorHighlighter());
        });
    }

    @NotNull
    public static DelegateColorScheme updateConsoleColorScheme(@NotNull EditorColorsScheme scheme) {
        return new DelegateColorScheme(scheme){

            @Override
            @NotNull
            public Color getDefaultBackground() {
                Color color = this.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
                return color == null ? super.getDefaultBackground() : color;
            }

            @Override
            @NotNull
            public FontPreferences getFontPreferences() {
                return this.getConsoleFontPreferences();
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public float getLineSpacing() {
                return this.getConsoleLineSpacing();
            }

            @Override
            @NotNull
            public Font getFont(EditorFontType key) {
                return super.getFont(EditorFontType.getConsoleType((EditorFontType)key));
            }

            @Override
            public void setEditorFontSize(int fontSize) {
                this.setConsoleFontSize(fontSize);
            }
        };
    }

    public static boolean isConsoleViewEditor(@NotNull Editor editor) {
        return editor.getEditorKind() == EditorKind.CONSOLE;
    }

    public static boolean isReplaceActionEnabledForConsoleViewEditor(@NotNull Editor editor) {
        return editor.getUserData(REPLACE_ACTION_ENABLED) == Boolean.TRUE;
    }

    public static void enableReplaceActionForConsoleViewEditor(@NotNull Editor editor) {
        editor.putUserData(REPLACE_ACTION_ENABLED, (Object)true);
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text, @NotNull SyntaxHighlighter highlighter) {
        ConsoleViewUtil.printWithHighlighting(console, text, highlighter, null);
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text, @NotNull SyntaxHighlighter highlighter, Runnable doOnNewLine) {
        IElementType tokenType;
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start((CharSequence)text, 0, text.length(), 0);
        while ((tokenType = lexer.getTokenType()) != null) {
            ConsoleViewContentType contentType = ConsoleViewUtil.getContentTypeForToken(tokenType, highlighter);
            StringTokenizer eolTokenizer = new StringTokenizer(lexer.getTokenText(), "\n", true);
            while (eolTokenizer.hasMoreTokens()) {
                String tok = eolTokenizer.nextToken();
                console.print(tok, contentType);
                if (doOnNewLine == null || !"\n".equals(tok)) continue;
                doOnNewLine.run();
            }
            lexer.advance();
        }
    }

    @NotNull
    public static ConsoleViewContentType getContentTypeForToken(@NotNull IElementType tokenType, @NotNull SyntaxHighlighter highlighter) {
        TextAttributesKey[] keys2 = highlighter.getTokenHighlights(tokenType);
        if (keys2.length == 0) {
            return ConsoleViewContentType.NORMAL_OUTPUT;
        }
        return ConsoleViewContentType.getConsoleViewType(ColorCache.keys.get(Arrays.asList(keys2)));
    }

    public static void printAsFileType(@NotNull ConsoleView console, @NotNull String text, @NotNull FileType fileType) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null);
        if (highlighter != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, highlighter);
        } else {
            console.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    @NotNull
    public static List<Filter> computeConsoleFilters(@NotNull Project project, @Nullable ConsoleView consoleView, @NotNull GlobalSearchScope searchScope) {
        ArrayList<Filter> result2 = new ArrayList<Filter>();
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions()) {
            Object[] filters = consoleView != null && eachProvider instanceof ConsoleDependentFilterProvider ? ((ConsoleDependentFilterProvider)eachProvider).getDefaultFilters(consoleView, project, searchScope) : (eachProvider instanceof ConsoleFilterProviderEx ? ((ConsoleFilterProviderEx)eachProvider).getDefaultFilters(project, searchScope) : eachProvider.getDefaultFilters(project));
            ContainerUtil.addAll(result2, (Object[])filters);
        }
        return result2;
    }

    private static final class ColorCache {
        static final Map<Key<?>, List<TextAttributesKey>> textAttributeKeys;
        static final Map<Key<?>, TextAttributes> mergedTextAttributes;
        static final Map<List<TextAttributesKey>, Key<?>> keys;

        private ColorCache() {
        }

        static {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(){

                public void lookAndFeelChanged(@NotNull LafManager source) {
                    mergedTextAttributes.clear();
                }
            });
            textAttributeKeys = new ConcurrentHashMap();
            mergedTextAttributes = ConcurrentFactoryMap.createMap(contentKey -> {
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes result2 = scheme.getAttributes(HighlighterColors.TEXT);
                for (TextAttributesKey key : textAttributeKeys.get(contentKey)) {
                    TextAttributes attributes = scheme.getAttributes(key);
                    if (attributes == null) continue;
                    result2 = TextAttributes.merge((TextAttributes)result2, (TextAttributes)attributes);
                }
                return result2;
            });
            keys = ConcurrentFactoryMap.createMap(keys2 -> {
                StringBuilder keyName = new StringBuilder("ConsoleViewUtil_");
                for (TextAttributesKey key : keys2) {
                    keyName.append("_").append(key.getExternalName());
                }
                final Key newKey = new Key(keyName.toString());
                textAttributeKeys.put((Key<?>)newKey, (List<TextAttributesKey>)keys2);
                ConsoleViewContentType contentType = new ConsoleViewContentType(keyName.toString(), new TextAttributes()){

                    public TextAttributes getAttributes() {
                        return mergedTextAttributes.get(newKey);
                    }
                };
                ConsoleViewContentType.registerNewConsoleViewType((Key)newKey, (ConsoleViewContentType)contentType);
                return newKey;
            });
        }
    }

    private static class NullEditorHighlighter
    extends EmptyEditorHighlighter {
        private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();

        NullEditorHighlighter() {
            super(NULL_ATTRIBUTES);
        }

        @Override
        public void setAttributes(TextAttributes attributes) {
        }

        @Override
        public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        }
    }
}

