/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ProcessStreamsSynchronizer;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewRunningState
extends ConsoleState {
    private final ConsoleViewImpl myConsole;
    private final ProcessHandler myProcessHandler;
    private final ConsoleState myFinishedStated;
    private final Writer myUserInputWriter;
    private final ProcessStreamsSynchronizer myStreamsSynchronizer;
    private final ProcessAdapter myProcessListener = new ProcessAdapter(){

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (outputType instanceof ProcessOutputType) {
                ConsoleViewRunningState.this.myStreamsSynchronizer.doWhenStreamsSynchronized(event.getText(), (ProcessOutputType)outputType, () -> ConsoleViewRunningState.this.print(event.getText(), outputType));
            } else {
                ConsoleViewRunningState.this.print(event.getText(), outputType);
            }
        }
    };

    public ConsoleViewRunningState(@NotNull ConsoleViewImpl console, @NotNull ProcessHandler processHandler2, @NotNull ConsoleState finishedStated, boolean attachToStdOut, boolean attachToStdIn) {
        OutputStream processInput;
        this.myConsole = console;
        this.myProcessHandler = processHandler2;
        this.myFinishedStated = finishedStated;
        ProcessStreamsSynchronizer processStreamsSynchronizer = this.myStreamsSynchronizer = attachToStdOut ? new ProcessStreamsSynchronizer((Disposable)console) : null;
        if (attachToStdOut) {
            processHandler2.addProcessListener((ProcessListener)this.myProcessListener);
        }
        this.myUserInputWriter = attachToStdIn ? ((processInput = this.myProcessHandler.getProcessInput()) == null ? null : ConsoleViewRunningState.createOutputStreamWriter(processInput, processHandler2)) : null;
    }

    private static OutputStreamWriter createOutputStreamWriter(OutputStream processInput, ProcessHandler processHandler2) {
        Charset charset = null;
        if (processHandler2 instanceof OSProcessHandler) {
            charset = ((OSProcessHandler)processHandler2).getCharset();
        }
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        return new OutputStreamWriter(processInput, charset);
    }

    private void print(@NotNull String text, @NotNull Key<?> outputType) {
        this.myConsole.print(text, ConsoleViewContentType.getConsoleViewType(outputType));
    }

    @Override
    @NotNull
    public ConsoleState dispose() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.removeProcessListener((ProcessListener)this.myProcessListener);
        }
        return this.myFinishedStated;
    }

    @Override
    public boolean isCommandLine(@NotNull String line) {
        return this.myProcessHandler instanceof BaseProcessHandler && line.equals(((BaseProcessHandler)this.myProcessHandler).getCommandLine());
    }

    @Override
    public boolean isFinished() {
        return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public boolean isRunning() {
        return this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public void sendUserInput(@NotNull String input) throws IOException {
        if (this.myUserInputWriter == null) {
            throw new IOException(ExecutionBundle.message((String)"no.user.process.input.error.message", (Object[])new Object[0]));
        }
        this.myUserInputWriter.write(input);
        this.myUserInputWriter.flush();
    }

    @Override
    @NotNull
    public ConsoleState attachTo(@NotNull ConsoleViewImpl console, ProcessHandler processHandler2) {
        return this.dispose().attachTo(console, processHandler2);
    }

    @Nullable
    ProcessStreamsSynchronizer getStreamsSynchronizer() {
        return this.myStreamsSynchronizer;
    }

    public String toString() {
        return "Running state";
    }
}

