/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends AbstractTreeNode<RunDashboardManager.RunDashboardService>
implements RunDashboardRunConfigurationNode {
    private final List<RunDashboardCustomizer> myCustomizers;
    private final UserDataHolder myUserDataHolder = new UserDataHolderBase();

    public RunConfigurationNode(Project project, @NotNull RunDashboardManager.RunDashboardService service, @NotNull List<RunDashboardCustomizer> customizers) {
        super(project, (Object)service);
        this.myCustomizers = customizers;
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        return ((RunDashboardManager.RunDashboardService)this.getValue()).getSettings();
    }

    @Nullable
    public RunContentDescriptor getDescriptor() {
        return ((RunDashboardManager.RunDashboardService)this.getValue()).getDescriptor();
    }

    @Nullable
    public Content getContent() {
        return ((RunDashboardManager.RunDashboardService)this.getValue()).getContent();
    }

    protected void update(@NotNull PresentationData presentation2) {
        RunnerAndConfigurationSettings configurationSettings = this.getConfigurationSettings();
        boolean isStored = RunManager.getInstance((Project)this.getProject()).hasSettings(configurationSettings);
        SimpleTextAttributes nameAttributes = isStored ? (this.getContent() != null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES) : SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
        presentation2.addText(configurationSettings.getName(), nameAttributes);
        Icon icon2 = this.getIcon(configurationSettings);
        presentation2.setIcon(isStored ? icon2 : IconLoader.createLazy(() -> IconLoader.getDisabledIcon((Icon)icon2)));
        for (RunDashboardCustomizer customizer : this.myCustomizers) {
            if (!customizer.updatePresentation(presentation2, (RunDashboardRunConfigurationNode)this)) continue;
            return;
        }
    }

    private Icon getIcon(RunnerAndConfigurationSettings configurationSettings) {
        Icon icon2 = null;
        RunDashboardRunConfigurationStatus status = this.getStatus();
        if (RunDashboardRunConfigurationStatus.STARTED.equals(status)) {
            icon2 = this.getExecutorIcon();
        } else if (RunDashboardRunConfigurationStatus.FAILED.equals(status)) {
            icon2 = status.getIcon();
        }
        if (icon2 == null) {
            icon2 = RunManagerEx.getInstanceEx(this.getProject()).getConfigurationIcon(configurationSettings);
        }
        return icon2;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        for (RunDashboardCustomizer customizer : this.myCustomizers) {
            Collection children2 = customizer.getChildren((RunDashboardRunConfigurationNode)this);
            if (children2 == null) continue;
            for (AbstractTreeNode child2 : children2) {
                child2.setParent((AbstractTreeNode)this);
            }
            return children2;
        }
        return Collections.emptyList();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myUserDataHolder.putUserData(key, value2);
    }

    @NotNull
    public List<RunDashboardCustomizer> getCustomizers() {
        return this.myCustomizers;
    }

    @NotNull
    public RunDashboardRunConfigurationStatus getStatus() {
        for (RunDashboardCustomizer customizer : this.myCustomizers) {
            RunDashboardRunConfigurationStatus status = customizer.getStatus((RunDashboardRunConfigurationNode)this);
            if (status == null) continue;
            return status;
        }
        return RunDashboardRunConfigurationStatus.getStatus((RunDashboardRunConfigurationNode)this);
    }

    @Nullable
    private Icon getExecutorIcon() {
        Executor executor;
        Content content2 = this.getContent();
        if (content2 != null && !RunContentManagerImpl.isTerminated(content2) && (executor = RunContentManagerImpl.getExecutorByContent(content2)) != null) {
            return executor.getIcon();
        }
        return null;
    }

    public String toString() {
        return this.getConfigurationSettings().getName();
    }
}

