/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunDashboardActionUtils {
    private RunDashboardActionUtils() {
    }

    @NotNull
    static JBIterable<RunDashboardRunConfigurationNode> getTargets(@NotNull AnActionEvent e) {
        return ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardRunConfigurationNode.class);
    }

    @Nullable
    static RunDashboardRunConfigurationNode getTarget(@NotNull AnActionEvent e) {
        return (RunDashboardRunConfigurationNode)ServiceViewActionUtils.getTarget((AnActionEvent)e, RunDashboardRunConfigurationNode.class);
    }

    @NotNull
    static JBIterable<RunDashboardRunConfigurationNode> getLeafTargets(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return JBIterable.empty();
        }
        JBIterable roots = JBIterable.of((Object[])((Object[])e.getData(PlatformDataKeys.SELECTED_ITEMS)));
        LinkedHashSet<RunDashboardRunConfigurationNode> result2 = new LinkedHashSet<RunDashboardRunConfigurationNode>();
        if (!RunDashboardActionUtils.getLeaves(project, e, roots.toList(), Collections.emptyList(), result2)) {
            return JBIterable.empty();
        }
        return JBIterable.from(result2);
    }

    private static boolean getLeaves(Project project, AnActionEvent e, List<Object> items, List<Object> valueSubPath, Set<RunDashboardRunConfigurationNode> result2) {
        for (Object item : items) {
            if (item instanceof RunDashboardServiceViewContributor || item instanceof GroupingNode) {
                ArrayList<Object> itemSubPath = new ArrayList<Object>(valueSubPath);
                itemSubPath.add(item);
                List<Object> children2 = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).getChildrenSafe(e, itemSubPath);
                if (RunDashboardActionUtils.getLeaves(project, e, children2, itemSubPath, result2)) continue;
                return false;
            }
            if (item instanceof RunDashboardRunConfigurationNode) {
                result2.add((RunDashboardRunConfigurationNode)item);
                continue;
            }
            if (item instanceof AbstractTreeNode) {
                AbstractTreeNode parent = ((AbstractTreeNode)item).getParent();
                if (parent instanceof RunDashboardRunConfigurationNode) {
                    result2.add((RunDashboardRunConfigurationNode)parent);
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }
}

