/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.impl.statistics.RunConfigurationTypeUsagesCollector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "run.dashboard";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        HashSet<MetricEvent> metricEvents = new HashSet<MetricEvent>();
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        THashSet dashboardTypes = new THashSet(runDashboardManager.getTypes());
        dashboardTypes.removeAll(runDashboardManager.getEnableByDefaultTypes());
        metricEvents.add(MetricEventFactoryKt.newBooleanMetric((String)"run.dashboard", (!dashboardTypes.isEmpty() ? 1 : 0) != 0));
        if (!dashboardTypes.isEmpty()) {
            List configurationTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
            for (String dashboardType : dashboardTypes) {
                ConfigurationType configurationType = (ConfigurationType)ContainerUtil.find((Iterable)configurationTypes, type -> type.getId().equals(dashboardType));
                if (configurationType == null) continue;
                FeatureUsageData data2 = RunConfigurationTypeUsagesCollector.newFeatureUsageData(configurationType, null);
                metricEvents.add(MetricEventFactoryKt.newMetric((String)"added.run.configuration", (FeatureUsageData)data2));
            }
        }
        return metricEvents;
    }

    public static class RunConfigurationTypeValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_config".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (RunConfigurationTypeValidator.isThirdPartyValue((String)data2)) {
                return ValidationResultType.ACCEPTED;
            }
            ConfigurationType configurationType = RunConfigurationTypeValidator.findConfigurationTypeById(data2);
            if (configurationType == null) {
                return ValidationResultType.REJECTED;
            }
            return PluginInfoDetectorKt.getPluginInfo(configurationType.getClass()).isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }

        private static ConfigurationType findConfigurationTypeById(@NotNull String data2) {
            return (ConfigurationType)ContainerUtil.find((Iterable)ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), type -> type.getId().equals(data2));
        }
    }
}

