/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.RunIdeConsoleAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeConsoleRootType
extends ConsoleRootType {
    IdeConsoleRootType() {
        super("ide", ApplicationNamesInfo.getInstance().getProductName() + " Consoles");
    }

    @NotNull
    public static IdeConsoleRootType getInstance() {
        return (IdeConsoleRootType)IdeConsoleRootType.findByClass(IdeConsoleRootType.class);
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence());
        Icon icon2 = fileType == UnknownFileType.INSTANCE || fileType == PlainTextFileType.INSTANCE ? AllIcons.Debugger.Console : (Icon)ObjectUtils.notNull((Object)fileType.getIcon(), (Object)AllIcons.Debugger.Console);
        return LayeredIcon.create((Icon)icon2, (Icon)AllIcons.Nodes.RunnableMark);
    }

    public void fileOpened(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        RunIdeConsoleAction.configureConsole(file2, source);
    }
}

