/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffTypeFactory {
    @NotNull
    public static final TextDiffTypeImpl INSERTED = new TextDiffTypeImpl(DiffColors.DIFF_INSERTED, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl DELETED = new TextDiffTypeImpl(DiffColors.DIFF_DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl MODIFIED = new TextDiffTypeImpl(DiffColors.DIFF_MODIFIED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl CONFLICT = new TextDiffTypeImpl(DiffColors.DIFF_CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]));
    private static final TextDiffTypeFactory ourInstance = new TextDiffTypeFactory();
    private final List<TextDiffTypeImpl> myTypes = new ArrayList<TextDiffTypeImpl>();
    private static final double MIDDLE_COLOR_FACTOR = 0.6;

    private TextDiffTypeFactory() {
        ContainerUtil.addAll(this.myTypes, (Object[])new TextDiffTypeImpl[]{INSERTED, DELETED, MODIFIED, CONFLICT});
    }

    @NotNull
    public synchronized TextDiffType createTextDiffType(@NonNls @NotNull TextAttributesKey key, @NotNull String name) {
        TextDiffTypeImpl type = new TextDiffTypeImpl(key, name);
        this.myTypes.add(type);
        return type;
    }

    public synchronized TextDiffTypeImpl[] getAllDiffTypes() {
        return this.myTypes.toArray(new TextDiffTypeImpl[0]);
    }

    public static TextDiffTypeFactory getInstance() {
        return ourInstance;
    }

    @NotNull
    public static Color getMiddleColor(@NotNull Color fg, @NotNull Color bg) {
        return ColorUtil.mix((Color)fg, (Color)bg, (double)0.6);
    }

    public static class TextDiffTypeImpl
    implements TextDiffType {
        @NotNull
        private final TextAttributesKey myKey;
        @NotNull
        private final String myName;

        public TextDiffTypeImpl(@NotNull TextAttributesKey key, @NotNull String name) {
            this.myKey = key;
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public TextAttributes getAttributes(@Nullable Editor editor) {
            if (editor == null) {
                return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myKey);
            }
            return editor.getColorsScheme().getAttributes(this.myKey);
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            return (Color)ObjectUtils.notNull((Object)this.getAttributes(editor).getBackgroundColor(), (Object)JBColor.DARK_GRAY);
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            Color color = this.getAttributes(editor).getForegroundColor();
            if (color != null) {
                return color;
            }
            Color fg = this.getColor(editor);
            Color bg = editor instanceof EditorEx ? ((EditorEx)editor).getBackgroundColor() : EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            return ColorUtil.mix((Color)fg, (Color)bg, (double)0.6);
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.getAttributes(editor).getErrorStripeColor();
        }

        @NotNull
        public TextAttributesKey getKey() {
            return this.myKey;
        }

        public String toString() {
            return this.myName;
        }
    }
}

