/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineMarkerRenderer$WhenMappings;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ@\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/diff/util/DiffLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "myHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "myDiffType", "Lcom/intellij/diff/util/TextDiffType;", "myEditorMode", "Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "myGutterMode", "myHideWithoutLineNumbers", "", "myEmptyRange", "myFirstLine", "myLastLine", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/diff/util/TextDiffType;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;ZZZZ)V", "drawMarker", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics2D;", "x1", "", "x2", "y1", "y2", "mode", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "paint", "Ljava/awt/Graphics;", "range", "Ljava/awt/Rectangle;", "intellij.platform.diff.impl"})
public final class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    private final RangeHighlighter myHighlighter;
    private final TextDiffType myDiffType;
    private final DiffDrawUtil.PaintMode myEditorMode;
    private final DiffDrawUtil.PaintMode myGutterMode;
    private final boolean myHideWithoutLineNumbers;
    private final boolean myEmptyRange;
    private final boolean myFirstLine;
    private final boolean myLastLine;

    /*
     * WARNING - void declaration
     */
    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle range2) {
        void y1;
        Editor editor2 = editor;
        if (editor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        EditorEx cfr_ignored_0 = (EditorEx)editor2;
        Graphics graphics = g;
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D cfr_ignored_1 = (Graphics2D)graphics;
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int x1 = 0;
        int x2 = x1 + gutter.getWidth();
        int startLine = 0;
        int endLine = 0;
        if (this.myEmptyRange) {
            startLine = this.myLastLine ? DiffUtil.getLineCount(((EditorEx)editor).getDocument()) : ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            endLine = startLine;
        } else {
            startLine = ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            endLine = ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getEndOffset()) + 1;
        }
        DiffDrawUtil.MarkerRange markerRange = DiffDrawUtil.getGutterMarkerPaintRange(editor, startLine, endLine);
        int n = markerRange.component1();
        int y2 = markerRange.component2();
        if (this.myHideWithoutLineNumbers && !editor.getSettings().isLineNumbersShown()) {
            x1 = gutter.getWhitespaceSeparatorOffset();
        } else {
            int annotationsOffset = gutter.getAnnotationsAreaOffset();
            int annotationsWidth = gutter.getAnnotationsAreaWidth();
            if (annotationsWidth != 0) {
                this.drawMarker(editor, (Graphics2D)g, x1, annotationsOffset, (int)y1, y2, this.myGutterMode);
                x1 = annotationsOffset + annotationsWidth;
            }
        }
        if (Intrinsics.areEqual((Object)this.myEditorMode, (Object)this.myGutterMode)) {
            this.drawMarker(editor, (Graphics2D)g, x1, x2, (int)y1, y2, this.myGutterMode);
        } else {
            int xOutline = gutter.getWhitespaceSeparatorOffset();
            this.drawMarker(editor, (Graphics2D)g, xOutline, x2, (int)y1, y2, this.myEditorMode);
            this.drawMarker(editor, (Graphics2D)g, x1, xOutline, (int)y1, y2, this.myGutterMode);
        }
    }

    private final void drawMarker(Editor editor, Graphics2D g, int x1, int x2, int y1, int y2, DiffDrawUtil.PaintMode mode) {
        boolean isEmptyRange;
        Color color;
        if (x1 >= x2) {
            return;
        }
        boolean dottedLine = mode.border == DiffDrawUtil.BorderType.DOTTED;
        Color color2 = this.myDiffType.getColor(editor);
        switch (DiffLineMarkerRenderer$WhenMappings.$EnumSwitchMapping$0[mode.background.ordinal()]) {
            case 1: {
                color = null;
                break;
            }
            case 2: {
                color = color2;
                break;
            }
            case 3: {
                color = this.myDiffType.getIgnoredColor(editor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Color backgroundColor = color;
        boolean bl = isEmptyRange = y2 - y1 <= 2;
        if (!isEmptyRange) {
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
            }
            if (mode.border != DiffDrawUtil.BorderType.NONE) {
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1, color2, false, dottedLine);
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y2 - 1, color2, false, dottedLine);
            }
        } else {
            DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1 - 1, color2, true, dottedLine);
        }
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }

    public DiffLineMarkerRenderer(@NotNull RangeHighlighter myHighlighter, @NotNull TextDiffType myDiffType, @NotNull DiffDrawUtil.PaintMode myEditorMode, @NotNull DiffDrawUtil.PaintMode myGutterMode, boolean myHideWithoutLineNumbers, boolean myEmptyRange, boolean myFirstLine, boolean myLastLine) {
        this.myHighlighter = myHighlighter;
        this.myDiffType = myDiffType;
        this.myEditorMode = myEditorMode;
        this.myGutterMode = myGutterMode;
        this.myHideWithoutLineNumbers = myHideWithoutLineNumbers;
        this.myEmptyRange = myEmptyRange;
        this.myFirstLine = myFirstLine;
        this.myLastLine = myLastLine;
    }
}

