/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListenerDiffViewerBase
extends DiffViewerBase {
    public ListenerDiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request2) {
        super(context, request2);
    }

    @Override
    protected void onInit() {
        super.onInit();
        BulkFileListener fileListener = this.createFileListener(this.myRequest);
        if (fileListener != null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)fileListener);
        }
        DocumentListener documentListener = this.createDocumentListener();
        List documents = ContainerUtil.mapNotNull((Collection)this.myRequest.getContents(), content2 -> content2 instanceof DocumentContent ? ((DocumentContent)content2).getDocument() : null);
        TextDiffViewerUtil.installDocumentListeners(documentListener, documents, (Disposable)this);
    }

    @NotNull
    protected DocumentListener createDocumentListener() {
        return new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                ListenerDiffViewerBase.this.onBeforeDocumentChange(event);
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                ListenerDiffViewerBase.this.onDocumentChange(event);
            }
        };
    }

    @Nullable
    protected BulkFileListener createFileListener(@NotNull ContentDiffRequest request2) {
        final ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(0);
        for (DiffContent content2 : request2.getContents()) {
            if (!(content2 instanceof FileContent) || content2 instanceof DocumentContent) continue;
            files2.add(((FileContent)content2).getFile());
        }
        if (files2.isEmpty()) {
            return null;
        }
        return new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (!(vFileEvent instanceof VFileContentChangeEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent) || !files2.contains(file2 = Objects.requireNonNull(vFileEvent.getFile()))) continue;
                    ListenerDiffViewerBase.this.onFileChange(file2);
                }
            }
        };
    }

    protected void onDocumentChange(@NotNull DocumentEvent event) {
        this.scheduleRediff();
    }

    protected void onBeforeDocumentChange(@NotNull DocumentEvent event) {
    }

    protected void onFileChange(@NotNull VirtualFile file2) {
        this.scheduleRediff();
    }

    @Deprecated
    protected void onFileChange(@NotNull VirtualFileEvent event) {
        this.onFileChange(event.getFile());
    }
}

