/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffNotifications {
    @NotNull
    public static JPanel createInsertedContent() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"notification.status.content.added", (Object[])new Object[0]), TextDiffType.INSERTED.getColor(null));
    }

    @NotNull
    public static JPanel createRemovedContent() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"notification.status.content.removed", (Object[])new Object[0]), TextDiffType.DELETED.getColor(null));
    }

    @NotNull
    public static JPanel createEqualContents() {
        return DiffNotifications.createEqualContents(true, true);
    }

    @NotNull
    public static JPanel createEqualContents(boolean equalCharsets, boolean equalSeparators) {
        if (!equalCharsets && !equalSeparators) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.and.line.separators.message.text", (Object[])new Object[0]));
        }
        if (!equalSeparators) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]));
        }
        if (!equalCharsets) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.message.text", (Object[])new Object[0]));
        }
        return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createError() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"diff.cant.calculate.diff", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createOperationCanceled() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"error.can.not.calculate.diff.operation.canceled", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createDiffTooBig() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"error.can.not.calculate.diff.file.too.big", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createNotification(@NotNull @Nls String text) {
        return DiffNotifications.createNotification(text, null);
    }

    @NotNull
    public static JPanel createNotification(@NotNull @Nls String text, @Nullable Color background) {
        return DiffNotifications.createNotification(text, background, true);
    }

    @NotNull
    public static JPanel createNotification(@NotNull @Nls String text, @Nullable Color background, boolean showHideAction) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel(background);
        panel2.text(text);
        if (showHideAction) {
            HyperlinkLabel link = panel2.createActionLabel(DiffBundle.message((String)"button.hide.notification", (Object[])new Object[0]), () -> panel2.setVisible(false));
            link.setToolTipText(DiffBundle.message((String)"hide.this.notification", (Object[])new Object[0]));
        }
        return panel2;
    }
}

