/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffChangeBase {
    @NotNull
    private final MergeConflictType myType;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    @NotNull
    protected final List<RangeHighlighter> myInnerHighlighters = new ArrayList<RangeHighlighter>();
    @NotNull
    protected final List<DiffGutterOperation> myOperations = new ArrayList<DiffGutterOperation>();

    public ThreesideDiffChangeBase(@NotNull MergeConflictType type) {
        this.myType = type;
    }

    public void destroy() {
        this.destroyHighlighters();
        this.destroyInnerHighlighters();
        this.destroyOperations();
    }

    protected void installHighlighters() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    protected void installInnerHighlighters() {
        assert (this.myInnerHighlighters.isEmpty());
        this.createInnerHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createInnerHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createInnerHighlighter(ThreeSide.RIGHT);
        }
    }

    protected void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    protected void destroyInnerHighlighters() {
        for (RangeHighlighter highlighter : this.myInnerHighlighters) {
            highlighter.dispose();
        }
        this.myInnerHighlighters.clear();
    }

    protected void installOperations() {
    }

    protected void destroyOperations() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public void updateGutterActions(boolean force) {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    public abstract boolean isResolved(@NotNull ThreeSide var1);

    @NotNull
    protected abstract Editor getEditor(@NotNull ThreeSide var1);

    @Nullable
    protected abstract MergeInnerDifferences getInnerFragments();

    @NotNull
    public TextDiffType getDiffType() {
        return this.myType.getDiffType();
    }

    @NotNull
    public MergeConflictType getType() {
        return this.myType;
    }

    public boolean isConflict() {
        return this.getDiffType() == TextDiffType.CONFLICT;
    }

    public boolean isChange(@NotNull Side side) {
        return this.myType.isChange(side);
    }

    public boolean isChange(@NotNull ThreeSide side) {
        return this.myType.isChange(side);
    }

    protected void createHighlighter(@NotNull ThreeSide side) {
        Editor editor = this.getEditor(side);
        TextDiffType type = this.getDiffType();
        int startLine = this.getStartLine(side);
        int endLine = this.getEndLine(side);
        boolean resolved = this.isResolved(side);
        boolean ignored = !resolved && this.getInnerFragments() != null;
        boolean shouldHideWithoutLineNumbers = side == ThreeSide.BASE && !this.isChange(Side.LEFT) && this.isChange(Side.RIGHT);
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(shouldHideWithoutLineNumbers).withHideStripeMarkers(side == ThreeSide.BASE).done());
    }

    protected void createInnerHighlighter(@NotNull ThreeSide side) {
        if (this.isResolved(side)) {
            return;
        }
        MergeInnerDifferences innerFragments = this.getInnerFragments();
        if (innerFragments == null) {
            return;
        }
        List<TextRange> ranges = innerFragments.get(side);
        if (ranges == null) {
            return;
        }
        Editor editor = this.getEditor(side);
        int start2 = DiffUtil.getLinesRange(editor.getDocument(), this.getStartLine(side), this.getEndLine(side)).getStartOffset();
        for (TextRange fragment : ranges) {
            int innerStart = start2 + fragment.getStartOffset();
            int innerEnd = start2 + fragment.getEndOffset();
            this.myInnerHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, innerStart, innerEnd, this.getDiffType()));
        }
    }
}

