/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffModel {
    @NotNull
    private final SimpleDiffViewer myViewer;
    @NotNull
    private final List<SimpleDiffChange> myValidChanges = new ArrayList<SimpleDiffChange>();
    @NotNull
    private final List<SimpleDiffChange> myAllChanges = new ArrayList<SimpleDiffChange>();
    @NotNull
    private ThreeState myIsContentsEqual = ThreeState.UNSURE;
    @NotNull
    private final List<SimpleDiffChangeUi> myPresentations = new ArrayList<SimpleDiffChangeUi>();

    public SimpleDiffModel(@NotNull SimpleDiffViewer viewer) {
        this.myViewer = viewer;
    }

    @NotNull
    public ThreeState isContentsEqual() {
        return this.myIsContentsEqual;
    }

    @NotNull
    public List<SimpleDiffChange> getChanges() {
        return this.myValidChanges;
    }

    @NotNull
    public List<SimpleDiffChange> getAllChanges() {
        return ContainerUtil.filter(this.myAllChanges, it -> !it.isDestroyed());
    }

    public void setChanges(@NotNull List<SimpleDiffChange> changes, boolean isContentsEqual) {
        this.clear();
        for (int i2 = 0; i2 < changes.size(); ++i2) {
            SimpleDiffChange change = changes.get(i2);
            SimpleDiffChange previousChange = i2 != 0 ? changes.get(i2 - 1) : null;
            SimpleDiffChangeUi changeUi = this.myViewer.createUi(change);
            changeUi.installHighlighter(previousChange);
            this.myPresentations.add(changeUi);
        }
        this.myValidChanges.addAll(changes);
        this.myAllChanges.addAll(changes);
        this.myIsContentsEqual = ThreeState.fromBoolean((boolean)isContentsEqual);
    }

    public void clear() {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.destroyHighlighter();
        }
        this.myValidChanges.clear();
        this.myAllChanges.clear();
        this.myPresentations.clear();
        this.myIsContentsEqual = ThreeState.UNSURE;
    }

    public void destroyChange(@NotNull SimpleDiffChange change) {
        SimpleDiffChangeUi changeUi = this.myPresentations.set(change.getIndex(), null);
        if (changeUi != null) {
            changeUi.destroyHighlighter();
        }
        this.myValidChanges.remove(change);
        change.markDestroyed();
    }

    public void updateGutterActions(boolean force) {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.updateGutterActions(force);
        }
    }

    public void handleBeforeDocumentChange(@NotNull Side side, @NotNull DocumentEvent e) {
        if (this.myValidChanges.isEmpty()) {
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleDiffChange> invalidated = new ArrayList<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myValidChanges) {
            if (!change.processDocumentChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalidated.add(change);
            SimpleDiffChangeUi changeUi = this.myPresentations.get(change.getIndex());
            if (changeUi == null) continue;
            changeUi.invalidate();
        }
        this.myValidChanges.removeAll(invalidated);
    }
}

