/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChangeUi {
    @NotNull
    protected final SimpleDiffViewer myViewer;
    @NotNull
    protected final SimpleDiffChange myChange;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    @NotNull
    protected final List<DiffGutterOperation> myOperations = new ArrayList<DiffGutterOperation>();

    public SimpleDiffChangeUi(@NotNull SimpleDiffViewer viewer, @NotNull SimpleDiffChange change) {
        this.myViewer = viewer;
        this.myChange = change;
    }

    public void installHighlighter(@Nullable SimpleDiffChange previousChange) {
        assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
        this.createHighlighter(Side.LEFT);
        this.createHighlighter(Side.RIGHT);
        List innerFragments = this.myChange.getFragment().getInnerFragments();
        for (DiffFragment fragment : ContainerUtil.notNullize((List)innerFragments)) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
        this.createNonSquashedChangesSeparator(previousChange, Side.LEFT);
        this.createNonSquashedChangesSeparator(previousChange, Side.RIGHT);
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    protected void doInstallActionHighlighters() {
        if (this.myChange.isSkipped()) {
            return;
        }
        this.myOperations.add(this.createAcceptOperation(Side.LEFT));
        this.myOperations.add(this.createAcceptOperation(Side.RIGHT));
    }

    private void createHighlighter(@NotNull Side side) {
        EditorEx editor = this.myViewer.getEditor(side);
        TextDiffType type = this.myChange.getDiffType();
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        boolean ignored = this.myChange.getFragment().getInnerFragments() != null;
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(this.myChange.isExcluded()).done());
    }

    private void createInlineHighlighter(@NotNull DiffFragment innerFragment, @NotNull Side side) {
        if (this.myChange.isSkipped()) {
            return;
        }
        int start2 = side.getStartOffset(innerFragment);
        int end = side.getEndOffset(innerFragment);
        TextDiffType type = DiffUtil.getDiffType(innerFragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editor = this.myViewer.getEditor(side);
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, start2 += startOffset, end += startOffset, type));
    }

    private void createNonSquashedChangesSeparator(@Nullable SimpleDiffChange previousChange, @NotNull Side side) {
        if (previousChange == null) {
            return;
        }
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        int prevStartLine = previousChange.getStartLine(side);
        int prevEndLine = previousChange.getEndLine(side);
        if (startLine == endLine) {
            return;
        }
        if (prevStartLine == prevEndLine) {
            return;
        }
        if (prevEndLine != startLine) {
            return;
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(this.myViewer.getEditor(side), startLine, TextDiffType.MODIFIED));
    }

    public void updateGutterActions(boolean force) {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public void invalidate() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull Side side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder2) {
        int offset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editor = this.myViewer.getEditor(side);
        return new DiffGutterOperation.WithModifiers(editor, offset, this.myViewer.getModifierProvider(), builder2);
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull Side side) {
        return this.createOperation(side, (ctrlPressed, shiftPressed, altPressed) -> {
            boolean isAppendable;
            boolean isOtherEditable = this.myViewer.isEditable(side.other());
            boolean bl = isAppendable = this.myChange.getDiffType() == TextDiffType.MODIFIED;
            if (isOtherEditable) {
                if (ctrlPressed && isAppendable) {
                    return this.createAppendRenderer(side);
                }
                return this.createApplyRenderer(side);
            }
            return null;
        });
    }

    private GutterIconRenderer createApplyRenderer(@NotNull Side side) {
        Icon icon2 = DiffUtil.getArrowIcon(side);
        String text = side == Side.LEFT && this.myViewer.isDiffForLocalChanges() ? DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]) : DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        String actionId = (String)side.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide");
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        String shortcutsText = StringUtil.nullize((String)KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
        String tooltipText = DiffUtil.createTooltipText(text, shortcutsText);
        return this.createIconRenderer(side, tooltipText, icon2, () -> this.myViewer.replaceChange(this.myChange, side));
    }

    private GutterIconRenderer createAppendRenderer(@NotNull Side side) {
        return this.createIconRenderer(side, DiffBundle.message((String)"action.presentation.diff.append.text", (Object[])new Object[0]), DiffUtil.getArrowDownIcon(side), () -> this.myViewer.appendChange(this.myChange, side));
    }

    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull @Nls String tooltipText, @NotNull Icon icon2, final @NotNull Runnable perform2) {
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (!SimpleDiffChangeUi.this.myChange.isValid()) {
                    return;
                }
                Project project = SimpleDiffChangeUi.this.myViewer.getProject();
                DocumentEx document = SimpleDiffChangeUi.this.myViewer.getEditor(sourceSide.other()).getDocument();
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), perform2);
            }
        };
    }
}

