/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnifiedFragmentBuilder {
    @NotNull
    protected final List<? extends LineFragment> myFragments;
    @NotNull
    private final Document myDocument1;
    @NotNull
    private final Document myDocument2;
    @NotNull
    private final Side myMasterSide;
    @NotNull
    private final StringBuilder myBuilder = new StringBuilder();
    @NotNull
    private final List<UnifiedDiffChange> myChanges = new ArrayList<UnifiedDiffChange>();
    @NotNull
    private final List<HighlightRange> myRanges = new ArrayList<HighlightRange>();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor1 = new LineNumberConvertor.Builder();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor2 = new LineNumberConvertor.Builder();
    @NotNull
    private final List<LineRange> myChangedLines = new ArrayList<LineRange>();
    private int lastProcessedLine1 = -1;
    private int lastProcessedLine2 = -1;
    private int totalLines = 0;

    public UnifiedFragmentBuilder(@NotNull List<? extends LineFragment> fragments, @NotNull Document document1, @NotNull Document document2, @NotNull Side masterSide) {
        this.myFragments = fragments;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
        this.myMasterSide = masterSide;
    }

    @NotNull
    public Side getMasterSide() {
        return this.myMasterSide;
    }

    public UnifiedFragmentBuilder exec() {
        if (this.myFragments.isEmpty()) {
            this.appendTextMaster(0, 0, UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
            return this;
        }
        for (int i2 = 0; i2 < this.myFragments.size(); ++i2) {
            LineFragment fragment = this.myFragments.get(i2);
            this.processEquals(fragment.getStartLine1() - 1, fragment.getStartLine2() - 1);
            this.processChanged(fragment, i2);
        }
        this.processEquals(UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
        return this;
    }

    private void processEquals(int endLine1, int endLine2) {
        int startLine1 = this.lastProcessedLine1 + 1;
        int startLine2 = this.lastProcessedLine2 + 1;
        this.appendTextMaster(startLine1, startLine2, endLine1, endLine2);
    }

    private void processChanged(@NotNull LineFragment fragment, int fragmentIndex) {
        int startLine1 = fragment.getStartLine1();
        int endLine1 = fragment.getEndLine1() - 1;
        int lines1 = endLine1 - startLine1;
        int startLine2 = fragment.getStartLine2();
        int endLine2 = fragment.getEndLine2() - 1;
        int lines2 = endLine2 - startLine2;
        int linesBefore = this.totalLines;
        if (lines1 >= 0) {
            int startOffset1 = this.myDocument1.getLineStartOffset(startLine1);
            int endOffset1 = this.myDocument1.getLineEndOffset(endLine1);
            this.appendText(Side.LEFT, startOffset1, endOffset1, lines1, lines2, startLine1, -1);
        }
        int linesBetween = this.totalLines;
        if (lines2 >= 0) {
            int startOffset2 = this.myDocument2.getLineStartOffset(startLine2);
            int endOffset2 = this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(Side.RIGHT, startOffset2, endOffset2, lines2, lines2, -1, startLine2);
        }
        int linesAfter = this.totalLines;
        UnifiedDiffChange change = this.createDiffChange(linesBefore, linesBetween, linesAfter, fragmentIndex);
        this.myChanges.add(change);
        if (!change.isSkipped()) {
            this.myChangedLines.add(new LineRange(linesBefore, linesAfter));
        }
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
    }

    @NotNull
    protected UnifiedDiffChange createDiffChange(int blockStart, int insertedStart, int blockEnd, int fragmentIndex) {
        return new UnifiedDiffChange(blockStart, insertedStart, blockEnd, this.myFragments.get(fragmentIndex));
    }

    private void appendTextMaster(int startLine1, int startLine2, int endLine1, int endLine2) {
        int lines1 = endLine1 - startLine1;
        int lines2 = endLine2 - startLine2;
        if (this.myMasterSide.select(lines1, lines2) >= 0) {
            int startOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineStartOffset(startLine1) : this.myDocument2.getLineStartOffset(startLine2);
            int endOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineEndOffset(endLine1) : this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(this.myMasterSide, startOffset, endOffset, lines1, lines2, startLine1, startLine2);
        }
    }

    private void appendText(@NotNull Side side, int offset1, int offset2, int lines1, int lines2, int startLine1, int startLine2) {
        int appendix;
        int lines = side.select(lines1, lines2);
        boolean notEmpty = lines >= 0;
        int n = appendix = notEmpty ? 1 : 0;
        if (startLine1 != -1) {
            this.myConvertor1.put(this.totalLines, startLine1, lines + appendix, lines1 + appendix);
        }
        if (startLine2 != -1) {
            this.myConvertor2.put(this.totalLines, startLine2, lines + appendix, lines2 + appendix);
        }
        if (notEmpty) {
            Document document = (Document)side.select((Object)this.myDocument1, (Object)this.myDocument2);
            int newline = document.getTextLength() > offset2 + 1 ? 1 : 0;
            TextRange base = new TextRange(this.myBuilder.length(), this.myBuilder.length() + offset2 - offset1 + newline);
            TextRange changed2 = new TextRange(offset1, offset2 + newline);
            this.myRanges.add(new HighlightRange(side, base, changed2));
            this.myBuilder.append(document.getCharsSequence().subSequence(offset1, offset2));
            this.myBuilder.append('\n');
            this.totalLines += lines + 1;
        }
    }

    private static int getLineCount(@NotNull Document document) {
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public CharSequence getText() {
        return this.myBuilder;
    }

    @NotNull
    public List<UnifiedDiffChange> getChanges() {
        return this.myChanges;
    }

    @NotNull
    public List<HighlightRange> getRanges() {
        return this.myRanges;
    }

    @NotNull
    public LineNumberConvertor getConvertor1() {
        return this.myConvertor1.build();
    }

    @NotNull
    public LineNumberConvertor getConvertor2() {
        return this.myConvertor2.build();
    }

    @NotNull
    public List<LineRange> getChangedLines() {
        return this.myChangedLines;
    }
}

