/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file2, @Nullable String title) {
        this(file2.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName, @Nullable String title) {
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(@NotNull DiffContext context) {
        return UnknownFileTypeDiffRequest.createComponent(this.myFileName, context);
    }

    @NotNull
    public static JComponent createComponent(@Nullable String fileName, @Nullable DiffContext context) {
        String message = DiffBundle.message((String)"error.cant.show.diff.for.unknown.file", (Object[])new Object[0]);
        if (fileName == null) {
            return DiffUtil.createMessagePanel(message);
        }
        return ErrorDiffTool.createReloadMessagePanel(context, message, DiffBundle.message((String)"button.associate.file.type", (Object[])new Object[0]), () -> FileTypeChooser.associateFileType(fileName));
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    private static void tryReloadRequest(@NotNull DiffContext context) {
        if (context instanceof DiffContextEx) {
            ((DiffContextEx)context).reloadDiffRequest();
        }
    }
}

