/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.Function;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result2, final @NotNull MergeRequest request2, final @NotNull MergeContext context, final @NotNull MergeTool.MergeViewer viewer, final boolean contentWasModified) {
        String caption = MergeUtil.getResolveActionTitle(result2, request2, context);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request2, context, contentWasModified)) {
                    return;
                }
                context.finishMerge(result2);
            }
        };
    }

    @Nls
    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result2, @Nullable MergeRequest request2, @Nullable MergeContext context) {
        String message;
        Function<MergeResult, String> getter = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS);
        String string = message = getter != null ? (String)getter.fun((Object)result2) : null;
        if (message != null) {
            return message;
        }
        switch (result2) {
            case CANCEL: {
                return DiffBundle.message((String)"button.merge.resolve.cancel", (Object[])new Object[0]);
            }
            case LEFT: {
                return DiffBundle.message((String)"button.merge.resolve.accept.left", (Object[])new Object[0]);
            }
            case RIGHT: {
                return DiffBundle.message((String)"button.merge.resolve.accept.right", (Object[])new Object[0]);
            }
            case RESOLVED: {
                return DiffBundle.message((String)"button.merge.resolve.apply", (Object[])new Object[0]);
            }
        }
        throw new IllegalArgumentException(result2.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]));
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]));
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        return Arrays.asList(left, base, right);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request2, @NotNull MergeContext context, boolean contentWasModified) {
        Condition<MergeTool.MergeViewer> customHandler = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER);
        if (customHandler != null) {
            return customHandler.value((Object)viewer);
        }
        return !contentWasModified || MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request2, context);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component2, @NotNull MergeRequest request2, @NotNull MergeContext context) {
        Couple<String> customMessage = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE);
        if (customMessage != null) {
            String message = (String)customMessage.second;
            String title = (String)customMessage.first;
            return Messages.showConfirmationDialog((JComponent)component2, (String)message, (String)title, (String)CommonBundle.message((String)"button.without.mnemonic.yes", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.without.mnemonic.no", (Object[])new Object[0])) == 0;
        }
        return MergeUtil.showConfirmDiscardChangesDialog(component2, DiffBundle.message((String)"button.cancel.merge", (Object[])new Object[0]), true);
    }

    public static boolean showConfirmDiscardChangesDialog(@NotNull JComponent parent, @NotNull @Nls String actionName, boolean contentWasModified) {
        if (!contentWasModified) {
            return true;
        }
        return Messages.showConfirmationDialog((JComponent)parent, (String)DiffBundle.message((String)"label.merge.unsaved.changes.discard.and.do.anyway", (Object[])new Object[]{actionName.toLowerCase(Locale.ENGLISH)}), (String)actionName, (String)DiffBundle.message((String)"button.discard.changes.and.do", (Object[])new Object[]{actionName}), (String)DiffBundle.message((String)"button.continue.merge", (Object[])new Object[0])) == 0;
    }

    public static boolean shouldRestoreOriginalContentOnCancel(@NotNull MergeRequest request2) {
        MergeCallback callback2 = MergeCallback.getCallback((MergeRequest)request2);
        if (callback2.checkIsValid()) {
            return true;
        }
        return Messages.showYesNoDialog((String)DiffBundle.message((String)"merge.conflict.is.outdated", (Object[])new Object[0]), (String)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.without.mnemonic.restore", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.without.mnemonic.do.nothing", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static void reportProjectFileChangeIfNeeded(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project != null && file2 != null && MergeUtil.isProjectFile(file2)) {
            StoreReloadManager.getInstance().saveChangedProjectFile(file2, project);
        }
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
            return true;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        return importProvider != null && importProvider.lookForProjectsInDirectory();
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocusedInWindow() {
            return this.myMergeContext.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            this.myMergeContext.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            return (T)this.myMergeContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            this.myMergeContext.putUserData(key, value2);
        }
    }
}

