/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.merge.ErrorMergeTool;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeContextEx;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MessageMergeViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergeContext myContext;
    @NotNull
    private final List<MergeTool> myAvailableTools;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    private final Wrapper myContentPanel;
    @NotNull
    private final Wrapper myToolbarPanel;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final Wrapper myNotificationPanel;
    @NotNull
    private final Wrapper myButtonsPanel;
    @Nullable
    private MergeRequest myRequest;
    @NotNull
    private MergeTool.MergeViewer myViewer;
    @Nullable
    private BooleanGetter myCloseHandler;
    private boolean myConflictResolved = false;

    public MergeRequestProcessor(@Nullable Project project) {
        this.myProject = project;
        this.myContext = new MyDiffContext();
        this.myContext.putUserData(DiffUserDataKeys.PLACE, (Object)"Merge");
        this.myAvailableTools = DiffManagerEx.getInstance().getMergeTools();
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarPanel = new Wrapper();
        this.myToolbarPanel.setFocusable(true);
        this.myToolbarStatusPanel = new Wrapper();
        this.myNotificationPanel = new Wrapper();
        this.myButtonsPanel = new Wrapper();
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myMainPanel);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarPanel).addToRight((Component)this.myToolbarStatusPanel).addToBottom((Component)this.myNotificationPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myMainPanel.add((Component)this.myButtonsPanel, "South");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.myViewer = new MessageMergeViewer(this.myContext, CommonBundle.getLoadingTreeNodeText());
    }

    public void init(@NotNull MergeRequest request2) {
        this.setTitle(request2.getTitle());
        this.myRequest = request2;
        this.myViewer = this.createViewerFor(request2);
        this.initViewer();
        this.installCallbackListener(this.myRequest);
    }

    public void init(@NotNull MergeRequestProducer request2) {
        this.setTitle(request2.getName());
        this.initViewer();
        ModalityState modality = ModalityState.stateForComponent((Component)this.myPanel);
        BackgroundTaskUtil.executeOnPooledThread(this, () -> {
            try {
                MergeRequest mergeRequest = request2.process((UserDataHolder)this.myContext, ProgressManager.getInstance().getProgressIndicator());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myDisposed) {
                        return;
                    }
                    this.myRequest = mergeRequest;
                    this.swapViewer(this.createViewerFor(mergeRequest));
                    this.installCallbackListener(this.myRequest);
                }, modality);
            }
            catch (Throwable e) {
                LOG.warn(e);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myDisposed) {
                        return;
                    }
                    this.swapViewer(new MessageMergeViewer(this.myContext, DiffBundle.message((String)"label.cant.show.merge.with.description", (Object[])new Object[]{e.getMessage()})));
                }, modality);
            }
        });
    }

    @NotNull
    private MergeTool.MergeViewer createViewerFor(@NotNull MergeRequest request2) {
        try {
            return this.getFittedTool(request2).createComponent(this.myContext, request2);
        }
        catch (Throwable e) {
            LOG.error(e);
            return ErrorMergeTool.INSTANCE.createComponent(this.myContext, request2);
        }
    }

    private void initViewer() {
        this.myContentPanel.setContent(this.myViewer.getComponent());
        MergeTool.ToolbarComponents toolbarComponents = this.myViewer.init();
        this.buildToolbar(toolbarComponents.toolbarActions);
        this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
        this.myCloseHandler = toolbarComponents.closeHandler;
        this.updateBottomActions();
    }

    private void destroyViewer() {
        Disposer.dispose((Disposable)this.myViewer);
        ActionUtil.clearActions((JComponent)this.myMainPanel);
        this.myContentPanel.setContent(null);
        this.myToolbarPanel.setContent(null);
        this.myToolbarStatusPanel.setContent(null);
        this.myButtonsPanel.setContent(null);
        this.myCloseHandler = null;
    }

    private void updateBottomActions() {
        Action applyLeft = this.myViewer.getResolveAction(MergeResult.LEFT);
        Action applyRight = this.myViewer.getResolveAction(MergeResult.RIGHT);
        final Action resolveAction = this.myViewer.getResolveAction(MergeResult.RESOLVED);
        Action cancelAction = this.myViewer.getResolveAction(MergeResult.CANCEL);
        if (resolveAction != null) {
            resolveAction.putValue("DefaultAction", true);
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    resolveAction.actionPerformed(null);
                }
            }.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, (JComponent)this.getRootPane(), (Disposable)this);
        }
        List leftActions = ContainerUtil.packNullables((Object[])new Action[]{applyLeft, applyRight});
        List rightActions = SystemInfo.isMac ? ContainerUtil.packNullables((Object[])new Action[]{cancelAction, resolveAction}) : ContainerUtil.packNullables((Object[])new Action[]{resolveAction, cancelAction});
        JRootPane rootPane = this.getRootPane();
        NonOpaquePanel buttonsPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        buttonsPanel.setBorder((Border)new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        if (leftActions.size() > 0) {
            buttonsPanel.add((Component)MergeRequestProcessor.createButtonsPanel(leftActions, rootPane), "West");
        }
        if (rightActions.size() > 0) {
            buttonsPanel.add((Component)MergeRequestProcessor.createButtonsPanel(rightActions, rootPane), "East");
        }
        this.myButtonsPanel.setContent((JComponent)buttonsPanel);
    }

    @NotNull
    private static JPanel createButtonsPanel(@NotNull List<? extends Action> actions, @Nullable JRootPane rootPane) {
        List buttons = ContainerUtil.map(actions, action2 -> DialogWrapper.createJButtonForAction((Action)action2, (JRootPane)rootPane));
        return DialogWrapper.layoutButtonsPanel((List)buttons);
    }

    @NotNull
    protected DefaultActionGroup collectToolbarActions(@Nullable List<? extends AnAction> viewerActions) {
        DefaultActionGroup group = new DefaultActionGroup();
        List<AnAction> navigationActions = Arrays.asList(new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction()});
        DiffUtil.addActionBlock(group, navigationActions);
        DiffUtil.addActionBlock(group, viewerActions);
        List requestContextActions = this.myRequest != null ? (List)this.myRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS) : null;
        DiffUtil.addActionBlock(group, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(group, contextActions);
        DiffUtil.addActionBlock(group, ActionManager.getInstance().getAction("ContextHelp"));
        return group;
    }

    protected void buildToolbar(@Nullable List<? extends AnAction> viewerActions) {
        DefaultActionGroup group = this.collectToolbarActions(viewerActions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)group, true);
        toolbar.setShowSeparatorTitles(true);
        DataManager.registerDataProvider((JComponent)toolbar.getComponent(), (DataProvider)this.myMainPanel);
        toolbar.setTargetComponent(toolbar.getComponent());
        this.myToolbarPanel.setContent(toolbar.getComponent());
        ActionUtil.recursiveRegisterShortcutSet((ActionGroup)group, (JComponent)this.myMainPanel, null);
    }

    @NotNull
    private MergeTool getFittedTool(@NotNull MergeRequest request2) {
        for (MergeTool tool : this.myAvailableTools) {
            try {
                if (!tool.canShow(this.myContext, request2)) continue;
                return tool;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return ErrorMergeTool.INSTANCE;
    }

    private void setTitle(@Nullable String title) {
        if (title == null) {
            title = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
        }
        this.setWindowTitle(title);
    }

    private void installCallbackListener(@NotNull MergeRequest request2) {
        MergeCallback callback2 = MergeCallback.getCallback((MergeRequest)request2);
        callback2.addListener(new MergeCallback.Listener(){

            public void fireConflictInvalid() {
                MergeRequestProcessor.this.showInvalidRequestNotification();
            }
        }, (Disposable)this);
        if (!callback2.checkIsValid()) {
            this.showInvalidRequestNotification();
        }
    }

    private void showInvalidRequestNotification() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myDisposed) {
                return;
            }
            if (!this.myNotificationPanel.isNull()) {
                return;
            }
            EditorNotificationPanel notification = new EditorNotificationPanel(LightColors.RED);
            notification.setText(DiffBundle.message((String)"error.conflict.is.not.valid.and.no.longer.can.be.resolved", (Object[])new Object[0]));
            notification.createActionLabel(DiffBundle.message((String)"button.abort.resolve", (Object[])new Object[0]), () -> {
                this.applyRequestResult(MergeResult.CANCEL);
                this.closeDialog();
            });
            this.myNotificationPanel.setContent((JComponent)notification);
            this.myMainPanel.validate();
            this.myMainPanel.repaint();
        }, ModalityState.stateForComponent((Component)this.myPanel));
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.destroyViewer();
            this.applyRequestResult(MergeResult.CANCEL);
        });
    }

    private void applyRequestResult(@NotNull MergeResult result2) {
        if (this.myConflictResolved || this.myRequest == null) {
            return;
        }
        this.myConflictResolved = true;
        try {
            this.myRequest.applyResult(result2);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            new Notification("Merge", DiffBundle.message((String)"can.t.finish.merge.resolve", (Object[])new Object[0]), e.getMessage(), NotificationType.ERROR).notify(this.myProject);
        }
    }

    private void reopenWithTool(@NotNull MergeTool tool) {
        MergeTool.MergeViewer newViewer;
        if (this.myRequest == null) {
            return;
        }
        if (this.myConflictResolved) {
            LOG.warn("Can't reopen with " + tool + " - conflict already resolved");
            return;
        }
        if (!tool.canShow(this.myContext, this.myRequest)) {
            LOG.warn("Can't reopen with " + tool + " - " + this.myRequest);
            return;
        }
        try {
            newViewer = tool.createComponent(this.myContext, this.myRequest);
        }
        catch (Throwable e) {
            LOG.error(e);
            return;
        }
        this.swapViewer(newViewer);
    }

    private void swapViewer(@NotNull MergeTool.MergeViewer newViewer) {
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            this.destroyViewer();
            this.myViewer = newViewer;
            this.initViewer();
        });
    }

    protected void onDispose() {
    }

    protected void setWindowTitle(@NotNull String title) {
    }

    public abstract void closeDialog();

    @Nullable
    protected abstract JRootPane getRootPane();

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myContext.putUserData(key, value2);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.myViewer.getPreferredFocusedComponent();
        return component2 != null ? component2 : this.myToolbarPanel.getTargetComponent();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public MergeContext getContext() {
        return this.myContext;
    }

    public boolean checkCloseAction() {
        return this.myConflictResolved || this.myCloseHandler == null || this.myCloseHandler.get();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow(this.myPanel);
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    private class MyDiffContext
    extends MergeContextEx {
        private MyDiffContext() {
        }

        @Nullable
        public Project getProject() {
            return MergeRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return MergeRequestProcessor.this.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            MergeRequestProcessor.this.requestFocusInWindow();
        }

        public void finishMerge(@NotNull MergeResult result2) {
            MergeRequestProcessor.this.applyRequestResult(result2);
            MergeRequestProcessor.this.closeDialog();
        }

        @Override
        public void reopenWithTool(@NotNull MergeTool tool) {
            MergeRequestProcessor.this.reopenWithTool(tool);
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = MergeRequestProcessor.this.getPreferredFocusedComponent();
            if (component2 == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, this);
        }

        @Override
        @Nullable
        protected Project getProject() {
            return MergeRequestProcessor.this.myProject;
        }
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            DataProvider requestProvider;
            Object data2;
            DataProvider contentProvider = DataManagerImpl.getDataProviderEx(MergeRequestProcessor.this.myContentPanel.getTargetComponent());
            if (contentProvider != null && (data2 = contentProvider.getData(dataId)) != null) {
                return data2;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return MergeRequestProcessor.this.myProject;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                if (MergeRequestProcessor.this.myRequest != null && MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "procedures.vcWithIDEA.commonVcsOps.integrateDiffs.resolveConflict";
            }
            if (DiffDataKeys.MERGE_VIEWER.is(dataId)) {
                return MergeRequestProcessor.this.myViewer;
            }
            DataProvider dataProvider = requestProvider = MergeRequestProcessor.this.myRequest != null ? (DataProvider)MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER) : null;
            if (requestProvider != null && (data2 = requestProvider.getData(dataId)) != null) {
                return data2;
            }
            DataProvider contextProvider = (DataProvider)MergeRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data2 = contextProvider.getData(dataId)) != null) {
                return data2;
            }
            return null;
        }
    }

    private static class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        private MyPrevDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabled(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoPrev()) {
                iterable.goPrev();
            }
        }
    }

    private static class MyNextDifferenceAction
    extends NextDifferenceAction {
        private MyNextDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabled(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoNext()) {
                iterable.goNext();
            }
        }
    }
}

