/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.impl.CacheDiffRequestChainProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffWindowBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffWindow
extends DiffWindowBase {
    @NotNull
    private final DiffRequestChain myRequestChain;

    public DiffWindow(@Nullable Project project, @NotNull DiffRequestChain requestChain, @NotNull DiffDialogHints hints2) {
        super(project, hints2);
        this.myRequestChain = requestChain;
    }

    @Override
    @NotNull
    protected DiffRequestProcessor createProcessor() {
        return new MyCacheDiffRequestChainProcessor(this.myProject, this.myRequestChain);
    }

    private class MyCacheDiffRequestChainProcessor
    extends CacheDiffRequestChainProcessor {
        MyCacheDiffRequestChainProcessor(@NotNull Project project, DiffRequestChain requestChain) {
            super(project, requestChain);
        }

        @Override
        protected void setWindowTitle(@NotNull String title) {
            DiffWindow.this.getWrapper().setTitle(title);
        }

        @Override
        protected void onAfterNavigate() {
            DiffUtil.closeWindow(DiffWindow.this.getWrapper().getWindow(), true, true);
        }
    }
}

