/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheDiffRequestChainProcessor
extends CacheDiffRequestProcessor.Simple {
    @NotNull
    private final DiffRequestChain myRequestChain;
    private int myIndex;

    public CacheDiffRequestChainProcessor(@Nullable Project project, @NotNull DiffRequestChain requestChain) {
        super(project, (UserDataHolder)requestChain);
        this.myRequestChain = requestChain;
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(true);
            ((AsyncDiffRequestChain)this.myRequestChain).addListener(new MyChangeListener(), this);
        }
        this.myIndex = this.myRequestChain.getIndex();
    }

    @Override
    protected void onDispose() {
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(false);
        }
        super.onDispose();
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        List requests = this.myRequestChain.getRequests();
        if (this.myIndex < 0 || this.myIndex >= requests.size()) {
            return null;
        }
        return (DiffRequestProducer)requests.get(this.myIndex);
    }

    @NotNull
    public DiffRequestChain getRequestChain() {
        return this.myRequestChain;
    }

    public void setCurrentRequest(int index) {
        this.myIndex = index;
        this.updateRequest();
    }

    @Override
    @NotNull
    protected List<AnAction> getNavigationActions() {
        return Arrays.asList(new AnAction[]{new DiffRequestProcessor.MyPrevDifferenceAction(this), new DiffRequestProcessor.MyNextDifferenceAction(this), new DiffRequestProcessor.MyOpenInEditorAction(this), Separator.getInstance(), new DiffRequestProcessor.MyPrevChangeAction(this), new DiffRequestProcessor.MyNextChangeAction(this), this.createGoToChangeAction()});
    }

    @Override
    protected boolean hasNextChange(boolean fromUpdate) {
        return this.myIndex < this.myRequestChain.getRequests().size() - 1;
    }

    @Override
    protected boolean hasPrevChange(boolean fromUpdate) {
        return this.myIndex > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequestChain.getRequests().size() > 1;
    }

    @NotNull
    private AnAction createGoToChangeAction() {
        AnAction action2 = GoToChangePopupBuilder.create(this.myRequestChain, (Consumer<Integer>)((Consumer)index -> {
            if (index >= 0 && index < this.myRequestChain.getRequests().size() && index != this.myIndex) {
                this.setCurrentRequest((int)index);
            }
        }), this.myIndex);
        if (DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DIFF_IN_EDITOR, new UserDataHolder[]{this.getContext()})) {
            CacheDiffRequestChainProcessor.patchShortcutSet(action2, "GotoClass", null);
        }
        return action2;
    }

    private class MyChangeListener
    implements AsyncDiffRequestChain.Listener {
        private MyChangeListener() {
        }

        @Override
        public void onRequestsLoaded() {
            CacheDiffRequestChainProcessor.this.dropCaches();
            CacheDiffRequestChainProcessor.this.myIndex = CacheDiffRequestChainProcessor.this.myRequestChain.getIndex();
            CacheDiffRequestChainProcessor.this.updateRequest(true);
        }
    }
}

