/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IntPair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparisonManagerImpl
extends ComparisonManager {
    @NotNull
    public static ComparisonManagerImpl getInstanceImpl() {
        return (ComparisonManagerImpl)ComparisonManagerImpl.getInstance();
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        LineOffsets lineOffsets1 = LineOffsetsUtil.create(text1);
        LineOffsets lineOffsets2 = LineOffsetsUtil.create(text2);
        return this.compareLines(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        Range range2 = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        return this.compareLines(range2, text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(range2.start1, range2.end1, text1, lineOffsets1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(range2.start2, range2.end2, text2, lineOffsets2);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, policy, indicator);
        return ComparisonManagerImpl.convertIntoLineFragments(range2, lineOffsets1, lineOffsets2, iterable);
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(text2);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        List<MergeRange> ranges = ByLine.compare(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        return ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
    }

    @NotNull
    public List<MergeLineFragment> mergeLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(text2);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        List<MergeRange> ranges = ByLine.merge(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        return ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        return ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, InnerFragmentsPolicy.WORDS, indicator);
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<LineFragment> lineFragments = this.compareLines(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            return ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, fragmentsPolicy, indicator);
        }
        return lineFragments;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, boolean innerFragments, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        InnerFragmentsPolicy fragmentsPolicy = innerFragments ? InnerFragmentsPolicy.WORDS : InnerFragmentsPolicy.NONE;
        return this.compareLinesInner(range2, text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator);
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<LineFragment> lineFragments = this.compareLines(range2, text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            return ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, fragmentsPolicy, indicator);
        }
        return lineFragments;
    }

    private static List<LineFragment> createInnerFragments(@NotNull List<? extends LineFragment> lineFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) {
        ArrayList<LineFragment> result2 = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment lineFragment : lineFragments) {
            assert (lineFragment.getInnerFragments() == null);
            try {
                boolean tryComputeDifferences = tooBigChunksCount < 3;
                result2.addAll(ComparisonManagerImpl.createInnerFragments(lineFragment, text1, text2, policy, fragmentsPolicy, indicator, tryComputeDifferences));
            }
            catch (DiffTooBigException e) {
                result2.add(lineFragment);
                ++tooBigChunksCount;
            }
        }
        return result2;
    }

    @NotNull
    private static List<LineFragment> createInnerFragments(@NotNull LineFragment fragment, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator, boolean tryComputeDifferences) throws DiffTooBigException {
        if (fragmentsPolicy == InnerFragmentsPolicy.NONE) {
            return Collections.singletonList(fragment);
        }
        CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
        CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            if (ComparisonUtil.isEquals(subSequence1, subSequence2, policy)) {
                return Collections.singletonList(new LineFragmentImpl(fragment, Collections.emptyList()));
            }
            return Collections.singletonList(fragment);
        }
        if (!tryComputeDifferences) {
            return Collections.singletonList(fragment);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.WORDS) {
            return ComparisonManagerImpl.createInnerWordFragments(fragment, subSequence1, subSequence2, policy, indicator);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.CHARS) {
            return ComparisonManagerImpl.createInnerCharFragments(fragment, subSequence1, subSequence2, policy, indicator);
        }
        throw new IllegalArgumentException(fragmentsPolicy.name());
    }

    @NotNull
    private static List<LineFragment> createInnerWordFragments(@NotNull LineFragment fragment, @NotNull CharSequence subSequence1, @NotNull CharSequence subSequence2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<ByWord.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
        assert (lineBlocks.size() != 0);
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        int currentStartLine1 = fragment.getStartLine1();
        int currentStartLine2 = fragment.getStartLine2();
        ArrayList<LineFragment> chunks = new ArrayList<LineFragment>();
        for (int i2 = 0; i2 < lineBlocks.size(); ++i2) {
            ByWord.LineBlock block = lineBlocks.get(i2);
            Range offsets2 = block.offsets;
            int currentEndLine1 = i2 != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
            int currentEndLine2 = i2 != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
            chunks.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets2.start1 + startOffset1, offsets2.end1 + startOffset1, offsets2.start2 + startOffset2, offsets2.end2 + startOffset2, block.fragments));
            currentStartLine1 = currentEndLine1;
            currentStartLine2 = currentEndLine2;
        }
        return chunks;
    }

    @NotNull
    private static List<LineFragment> createInnerCharFragments(@NotNull LineFragment fragment, @NotNull CharSequence subSequence1, @NotNull CharSequence subSequence2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<DiffFragment> innerChanges = ComparisonManagerImpl.doCompareChars(subSequence1, subSequence2, policy, indicator);
        return Collections.singletonList(new LineFragmentImpl(fragment, innerChanges));
    }

    @NotNull
    private static List<DiffFragment> doCompareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        DiffIterable iterable = policy == ComparisonPolicy.DEFAULT ? ByChar.compareTwoStep(text1, text2, indicator) : (policy == ComparisonPolicy.TRIM_WHITESPACES ? ByChar.compareTrimWhitespaces(text1, text2, indicator) : ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
        return ComparisonManagerImpl.convertIntoDiffFragments(iterable);
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return this.compareLinesInner(text1, text2, policy, indicator);
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return ByWord.compare(text1, text2, policy, indicator);
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return ComparisonManagerImpl.doCompareChars(text1, text2, policy, indicator);
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        return fragments;
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull Range range2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull DiffIterable changes) {
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes.iterateChanges()) {
            int startLine1 = ch.start1 + range2.start1;
            int startLine2 = ch.start2 + range2.start2;
            int endLine1 = ch.end1 + range2.start1;
            int endLine2 = ch.end2 + range2.start2;
            IntPair offsets1 = ComparisonManagerImpl.getOffsets(lineOffsets1, startLine1, endLine1);
            IntPair offsets2 = ComparisonManagerImpl.getOffsets(lineOffsets2, startLine2, endLine2);
            fragments.add((LineFragment)new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, offsets1.first, offsets1.second, offsets2.first, offsets2.second));
        }
        return fragments;
    }

    @NotNull
    private static IntPair getOffsets(@NotNull LineOffsets lineOffsets, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            int offset = startIndex < lineOffsets.getLineCount() ? lineOffsets.getLineStart(startIndex) : lineOffsets.getLineEnd(lineOffsets.getLineCount() - 1, true);
            return new IntPair(offset, offset);
        }
        int offset1 = lineOffsets.getLineStart(startIndex);
        int offset2 = lineOffsets.getLineEnd(endIndex - 1, true);
        return new IntPair(offset1, offset2);
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<? extends MergeRange> conflicts) {
        return ContainerUtil.map(conflicts, ch -> new MergeLineFragmentImpl((MergeRange)ch));
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<? extends MergeRange> conflicts) {
        return ContainerUtil.map(conflicts, ch -> new MergeWordFragmentImpl((MergeRange)ch));
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments.isEmpty()) {
            return oldFragments;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<? super List<? extends LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        return newFragments;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (!squash && !trim) {
            return oldFragments;
        }
        if (oldFragments.isEmpty()) {
            return oldFragments;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<? super List<? extends LineFragment>>)((Consumer)fragments -> newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim))));
        return newFragments;
    }

    private static void processAdjoining(@NotNull List<? extends LineFragment> oldFragments, @NotNull Consumer<? super List<? extends LineFragment>> consumer) {
        int startIndex = 0;
        for (int i2 = 1; i2 < oldFragments.size(); ++i2) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i2 - 1), oldFragments.get(i2))) continue;
            consumer.consume(oldFragments.subList(startIndex, i2));
            startIndex = i2;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<? extends LineFragment> processAdjoining(@NotNull List<? extends LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start2;
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start2 = 0; start2 < end; ++start2) {
                fragment = fragments.get(start2);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start2 < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start2 == end) {
            return Collections.emptyList();
        }
        if (squash) {
            return Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start2, end)));
        }
        return fragments.subList(start2, end);
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<? extends LineFragment> oldFragments) {
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            return oldFragments.get(0);
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment lineFragment : oldFragments) {
            for (DiffFragment innerFragment : ComparisonManagerImpl.extractInnerFragments(lineFragment)) {
                int shift1 = lineFragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = lineFragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, innerFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1() + shift1, innerFragment.getEndOffset1() + shift1, innerFragment.getStartOffset2() + shift2, innerFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), innerFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), innerFragment.getEndOffset2() + shift2));
            }
        }
        return new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment.getInnerFragments() != null) {
            return lineFragment.getInnerFragments();
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        return Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
    }

    @NotNull
    private static List<CharSequence> getLineContents(@NotNull CharSequence text) {
        LineOffsets lineOffsets = LineOffsetsUtil.create(text);
        return ComparisonManagerImpl.getLineContents(0, lineOffsets.getLineCount(), text, lineOffsets);
    }

    @NotNull
    private static List<CharSequence> getLineContents(int start2, int end, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>(end - start2);
        for (int line = start2; line < end; ++line) {
            lines.add((CharSequence)new CharSequenceSubSequence(text, lineOffsets.getLineStart(line), lineOffsets.getLineEnd(line)));
        }
        return lines;
    }

    @NotNull
    private static List<CharSequence> getNotIgnoredLineContents(int start2, int end, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        StringBuilder sb = new StringBuilder();
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>(end - start2);
        for (int line = start2; line < end; ++line) {
            for (int offset = lineOffsets.getLineStart(line); offset < lineOffsets.getLineEnd(line); ++offset) {
                if (ignored.get(offset)) continue;
                sb.append(text.charAt(offset));
            }
            lines.add(sb.toString());
            sb.setLength(0);
        }
        return lines;
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        Range range2 = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        return this.compareLinesWithIgnoredRanges(range2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator);
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getNotIgnoredLineContents(range2.start1, range2.end1, text1, lineOffsets1, ignored1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getNotIgnoredLineContents(range2.start2, range2.end2, text2, lineOffsets2, ignored2);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, ComparisonPolicy.DEFAULT, indicator);
        FairDiffIterable correctedIterable = ComparisonManagerImpl.correctIgnoredRangesSecondStep(range2, iterable, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2);
        DiffIterable trimmedIterable = ComparisonManagerImpl.trimIgnoredLines(range2, correctedIterable, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2);
        List<LineFragment> lineFragments = ComparisonManagerImpl.convertIntoLineFragments(range2, lineOffsets1, lineOffsets2, trimmedIterable);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            lineFragments = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, ComparisonPolicy.DEFAULT, fragmentsPolicy, indicator);
        }
        return ContainerUtil.mapNotNull(lineFragments, fragment -> ComparisonManagerImpl.trimIgnoredInnerFragments(fragment, ignored1, ignored2));
    }

    @NotNull
    public static BitSet collectIgnoredRanges(@NotNull List<? extends TextRange> ignoredRanges) {
        BitSet set = new BitSet();
        for (TextRange textRange : ignoredRanges) {
            set.set(textRange.getStartOffset(), textRange.getEndOffset());
        }
        return set;
    }

    @NotNull
    private static FairDiffIterable correctIgnoredRangesSecondStep(@NotNull Range range2, @NotNull FairDiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(iterable.getLength1(), iterable.getLength2());
        for (Range ch : iterable.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i2 = 0; i2 < count; ++i2) {
                int index1 = ch.start1 + i2;
                int index2 = ch.start2 + i2;
                if (!ComparisonManagerImpl.areIgnoredEqualLines(range2.start1 + index1, range2.start2 + index2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2)) continue;
                builder2.markEqual(index1, index2);
            }
        }
        return DiffIterableUtil.fair(builder2.finish());
    }

    @NotNull
    private static DiffIterable trimIgnoredLines(@NotNull Range range2, @NotNull FairDiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        ArrayList<Range> changedRanges = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range trimmedRange = TrimUtil.trimExpandRange(ch.start1, ch.start2, ch.end1, ch.end2, (Function2<? super Integer, ? super Integer, Boolean>)((Function2)(index1, index2) -> ComparisonManagerImpl.areIgnoredEqualLines(range2.start1 + index1, range2.start2 + index2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2)), (Function1<? super Integer, Boolean>)((Function1)index -> ComparisonManagerImpl.isIgnoredLine(range2.start1 + index, lineOffsets1, ignored1)), (Function1<? super Integer, Boolean>)((Function1)index -> ComparisonManagerImpl.isIgnoredLine(range2.start2 + index, lineOffsets2, ignored2)));
            if (trimmedRange.isEmpty()) continue;
            changedRanges.add(trimmedRange);
        }
        return DiffIterableUtil.create(changedRanges, iterable.getLength1(), iterable.getLength2());
    }

    @Nullable
    private static LineFragment trimIgnoredInnerFragments(@NotNull LineFragment fragment, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (fragment.getInnerFragments() == null) {
            return fragment;
        }
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        List newInner = ContainerUtil.mapNotNull((Collection)fragment.getInnerFragments(), it -> {
            TextRange range1 = ComparisonManagerImpl.trimIgnoredRange(it.getStartOffset1(), it.getEndOffset1(), ignored1, startOffset1);
            TextRange range2 = ComparisonManagerImpl.trimIgnoredRange(it.getStartOffset2(), it.getEndOffset2(), ignored2, startOffset2);
            if (range1.isEmpty() && range2.isEmpty()) {
                return null;
            }
            return new DiffFragmentImpl(range1.getStartOffset(), range1.getEndOffset(), range2.getStartOffset(), range2.getEndOffset());
        });
        if (newInner.isEmpty()) {
            return null;
        }
        return new LineFragmentImpl(fragment, newInner);
    }

    private static boolean isIgnoredLine(int index, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        return ComparisonManagerImpl.isIgnoredRange(ignored, lineOffsets.getLineStart(index), lineOffsets.getLineEnd(index, true));
    }

    private static boolean areIgnoredEqualLines(int index1, int index2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        int end2;
        int start1 = lineOffsets1.getLineStart(index1);
        int end1 = lineOffsets1.getLineEnd(index1, true);
        int start2 = lineOffsets2.getLineStart(index2);
        Range range2 = TrimUtil.trimExpandText(text1, text2, start1, start2, end1, end2 = lineOffsets2.getLineEnd(index2, true), ignored1, ignored2);
        if (!range2.isEmpty()) {
            return false;
        }
        List<ByWord.InlineChunk> words1 = ComparisonManagerImpl.getNonIgnoredWords(index1, text1, lineOffsets1, ignored1);
        List<ByWord.InlineChunk> words2 = ComparisonManagerImpl.getNonIgnoredWords(index2, text2, lineOffsets2, ignored2);
        if (words1.size() != words2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < words1.size(); ++i2) {
            CharSequence word2;
            CharSequence word1 = ComparisonManagerImpl.getWordContent(index1, text1, lineOffsets1, words1.get(i2));
            if (StringUtil.equals((CharSequence)word1, (CharSequence)(word2 = ComparisonManagerImpl.getWordContent(index2, text2, lineOffsets2, words2.get(i2))))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<ByWord.InlineChunk> getNonIgnoredWords(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        int offset = lineOffsets.getLineStart(index);
        List<ByWord.InlineChunk> innerChunks = ByWord.getInlineChunks(ComparisonManagerImpl.getLineContent(index, text, lineOffsets));
        return ContainerUtil.filter(innerChunks, it -> it instanceof ByWord.WordChunk && !ComparisonManagerImpl.isIgnoredRange(ignored, offset + it.getOffset1(), offset + it.getOffset2()));
    }

    @NotNull
    private static CharSequence getWordContent(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull ByWord.InlineChunk word) {
        return ComparisonManagerImpl.getLineContent(index, text, lineOffsets).subSequence(word.getOffset1(), word.getOffset2());
    }

    @NotNull
    private static TextRange trimIgnoredRange(int start2, int end, @NotNull BitSet ignored, int offset) {
        IntPair intPair = TrimUtil.trim(offset + start2, offset + end, ignored);
        return new TextRange(intPair.first - offset, intPair.second - offset);
    }

    private static boolean isIgnoredRange(@NotNull BitSet ignored, int start2, int end) {
        return ignored.nextClearBit(start2) >= end;
    }

    @NotNull
    private static CharSequence getLineContent(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        return text.subSequence(lineOffsets.getLineStart(index), lineOffsets.getLineEnd(index, true));
    }
}

