/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import gnu.trove.THashMap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleManagerBase
implements LogConsoleManager,
Disposable {
    private final Project myProject;
    private final Map<AdditionalTabComponent, Content> myAdditionalContent = new THashMap();
    private final GlobalSearchScope mySearchScope;

    protected LogConsoleManagerBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        this.myProject = project;
        this.mySearchScope = searchScope;
    }

    @Override
    public void addLogConsole(@NotNull String name, final @NotNull String path, @NotNull Charset charset, long skippedContent, @NotNull RunConfigurationBase runConfiguration) {
        this.doAddLogConsole(new LogConsoleImpl(this.myProject, new File(path), charset, skippedContent, name, false, this.mySearchScope){

            @Override
            public boolean isActive() {
                return LogConsoleManagerBase.this.isConsoleActive(path);
            }
        }, path, this.getDefaultIcon(), (RunProfile)runConfiguration);
    }

    private void doAddLogConsole(final @NotNull LogConsoleBase log, String id2, Icon icon2, @Nullable RunProfile runProfile) {
        if (runProfile instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runProfile).customizeLogConsole((LogConsole)log);
        }
        log.attachStopLogConsoleTrackingListener(this.getProcessHandler());
        this.addAdditionalTabComponent(log, id2, icon2);
        this.getUi().addListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                log.activate();
            }
        }, (Disposable)log);
    }

    private boolean isConsoleActive(String id2) {
        Content content2 = this.getUi().findContent(id2);
        return content2 != null && content2.isSelected();
    }

    @Override
    public void removeLogConsole(@NotNull String path) {
        Content content2 = this.getUi().findContent(path);
        if (content2 != null) {
            this.removeAdditionalTabComponent((LogConsoleBase)((Object)content2.getComponent()));
        }
    }

    public void addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id2) {
        this.addAdditionalTabComponent(tabComponent, id2, this.getDefaultIcon());
    }

    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id2, @Nullable Icon icon2) {
        return this.addAdditionalTabComponent(tabComponent, id2, icon2, true);
    }

    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id2, @Nullable Icon icon2, boolean closeable) {
        Content logContent = this.getUi().createContent(id2, (ComponentWithActions)tabComponent, tabComponent.getTabTitle(), icon2, tabComponent.getPreferredFocusableComponent());
        logContent.setCloseable(closeable);
        this.myAdditionalContent.put(tabComponent, logContent);
        this.getUi().addContent(logContent);
        return logContent;
    }

    public void removeAdditionalTabComponent(@NotNull AdditionalTabComponent component2) {
        Disposer.dispose((Disposable)component2);
        Content content2 = this.myAdditionalContent.remove(component2);
        if (!this.getUi().isDisposed()) {
            this.getUi().removeContent(content2, true);
        }
    }

    public void dispose() {
        for (AdditionalTabComponent component2 : this.myAdditionalContent.keySet().toArray(new AdditionalTabComponent[0])) {
            this.removeAdditionalTabComponent(component2);
        }
    }

    protected abstract Icon getDefaultIcon();

    protected abstract RunnerLayoutUi getUi();

    public abstract ProcessHandler getProcessHandler();
}

