/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CoreProjectScopeBuilder
extends ProjectScopeBuilder {
    private final Project myProject;
    private final FileIndexFacade myFileIndexFacade;
    private final CoreLibrariesScope myLibrariesScope;

    public CoreProjectScopeBuilder(Project project, FileIndexFacade fileIndexFacade) {
        this.myFileIndexFacade = fileIndexFacade;
        this.myProject = project;
        this.myLibrariesScope = new CoreLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        return this.myLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        return new EverythingGlobalScope();
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        return new ProjectScopeImpl(this.myProject, this.myFileIndexFacade);
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        return new ContentSearchScope(this.myProject, this.myFileIndexFacade);
    }

    @NotNull
    public GlobalSearchScope buildEverythingScope() {
        return new EverythingGlobalScope(this.myProject);
    }

    public static class ContentSearchScope
    extends GlobalSearchScope {
        private final FileIndexFacade myFileIndexFacade;

        public ContentSearchScope(Project project, FileIndexFacade fileIndexFacade) {
            super(project);
            this.myFileIndexFacade = fileIndexFacade;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return this.myFileIndexFacade.isInContent(file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return this.myFileIndexFacade.getUnloadedModuleDescriptions();
        }
    }

    private class CoreLibrariesScope
    extends GlobalSearchScope {
        private CoreLibrariesScope() {
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibraryClasses(file2) || CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibrarySource(file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

