/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentCollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentIdentityMap() {
        return new ConcurrentHashMap(TObjectHashingStrategy.IDENTITY);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        return new ConcurrentHashMap(hashStrategy);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashStrategy) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> createConcurrentSet(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        return Collections.newSetFromMap(ConcurrentCollectionFactory.createMap(hashStrategy));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> createConcurrentSet(int initialCapacity, @NotNull TObjectHashingStrategy<T> hashStrategy) {
        return Collections.newSetFromMap(ConcurrentCollectionFactory.createMap(initialCapacity, 0.75f, 16, hashStrategy));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> createConcurrentSet(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashStrategy) {
        return Collections.newSetFromMap(ConcurrentCollectionFactory.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy));
    }
}

