/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class XmlWriterWrapper
implements Closeable {
    private final Project myProject;
    private final Path myOutputDirectory;
    private final String myName;
    private final String myRootTagName;
    private Writer myFileWriter;
    private JbXmlOutputter myOutputter;

    XmlWriterWrapper(@NotNull Project project, @NotNull Path outputDirectory, @NotNull String name, @NotNull String rootTagName) {
        this.myProject = project;
        this.myOutputDirectory = outputDirectory;
        this.myName = name;
        this.myRootTagName = rootTagName;
    }

    void writeElement(@NotNull Element element2) {
        try {
            this.checkOpen();
            this.myFileWriter.write(10);
            this.myOutputter.output(element2, this.myFileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void checkOpen() throws IOException {
        if (this.myFileWriter == null) {
            this.myFileWriter = XmlWriterWrapper.openFile(this.myOutputDirectory, this.myName);
            this.myOutputter = JbXmlOutputter.createOutputter((ComponentManager)this.myProject);
            this.startWritingXml();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myFileWriter == null) {
            return;
        }
        try {
            this.endWritingXml();
        }
        finally {
            Writer fileWriter = this.myFileWriter;
            this.myFileWriter = null;
            fileWriter.close();
        }
    }

    @NotNull
    private static Writer openFile(@NotNull Path outputDirectory, @NotNull String name) throws IOException {
        return InspectionsResultUtil.getWriter(outputDirectory, name);
    }

    private void startWritingXml() throws IOException {
        this.myFileWriter.write(60);
        this.myFileWriter.write(this.myRootTagName);
        this.myFileWriter.write(62);
    }

    private void endWritingXml() throws IOException {
        try {
            this.myFileWriter.write("\n");
            this.myFileWriter.write(60);
            this.myFileWriter.write(47);
            this.myFileWriter.write(this.myRootTagName);
            this.myFileWriter.write(62);
        }
        finally {
            this.myFileWriter.close();
        }
    }
}

