/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Interner;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends SuppressableInspectionTreeNode {
    private final CommonProblemDescriptor myDescriptor;
    private final HighlightDisplayLevel myLevel;
    protected final int myLineNumber;
    protected final RefEntity myElement;
    private static final Interner<String> NAME_INTERNER = Interner.createWeakInterner();

    public ProblemDescriptionNode(RefEntity element2, @NotNull CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent) {
        this(element2, descriptor2, presentation2, null, parent);
    }

    protected ProblemDescriptionNode(@Nullable RefEntity element2, CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2, @Nullable IntSupplier lineNumberCounter, @NotNull InspectionTreeNode parent) {
        super(presentation2, parent);
        this.myElement = element2;
        this.myDescriptor = descriptor2;
        this.myLevel = (HighlightDisplayLevel)ObjectUtils.notNull((Object)ProblemDescriptionNode.calculatePreciseLevel(element2, descriptor2, presentation2), () -> {
            String shortName = presentation2.getToolWrapper().getShortName();
            InspectionProfileImpl profile = presentation2.getContext().getCurrentProfile();
            return profile.getTools(shortName, presentation2.getContext().getProject()).getLevel();
        });
        this.myLineNumber = this.myDescriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)this.myDescriptor).getLineNumber() : (lineNumberCounter == null ? -1 : lineNumberCounter.getAsInt());
    }

    private static HighlightDisplayLevel calculatePreciseLevel(@Nullable RefEntity element2, @Nullable CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2) {
        if (element2 == null) {
            return null;
        }
        InspectionProfileImpl profile = presentation2.getContext().getCurrentProfile();
        String shortName = presentation2.getToolWrapper().getShortName();
        if (descriptor2 instanceof ProblemDescriptor) {
            BaseInspectionProfileManager inspectionProfileManager = profile.getProfileManager();
            RefElement refElement = (RefElement)element2;
            SeverityRegistrar severityRegistrar = inspectionProfileManager.getSeverityRegistrar();
            HighlightSeverity severity = presentation2.getSeverity(refElement);
            if (severity == null) {
                return null;
            }
            HighlightInfoType highlightInfoType = ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor2, severity, severityRegistrar);
            HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(refElement.getPsiElement());
            return HighlightDisplayLevel.find((HighlightSeverity)highlightSeverity);
        }
        return profile.getTools(shortName, presentation2.getContext().getProject()).getLevel();
    }

    @Nullable
    public String getToolTipText() {
        if (!this.isValid()) {
            return null;
        }
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            return null;
        }
        PsiElement element2 = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        String message = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element2, false);
        if (XmlStringUtil.isWrappedInHtml((String)message)) {
            return message;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)message));
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.myDescriptor != null && this.getPresentation().isSuppressed(this.myDescriptor);
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public boolean canSuppress() {
        return super.canSuppress() && !this.isQuickFixAppliedFromView();
    }

    @NotNull
    public InspectionToolWrapper<?, ?> getToolWrapper() {
        return this.getPresentation().getToolWrapper();
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public void excludeElement() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 != null) {
            this.getPresentation().exclude(descriptor2);
        }
    }

    @Override
    public void amnestyElement() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 != null) {
            this.getPresentation().amnesty(descriptor2);
        }
    }

    @Override
    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (this.isValid() && !this.isExcluded() && !this.isQuickFixAppliedFromView() && !this.isAlreadySuppressedFromView()) {
            counter.put((Object)this.myLevel, counter.get((Object)this.myLevel) + 1);
        }
    }

    @Override
    protected boolean calculateIsValid() {
        if (this.myDescriptor == null) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (this.myDescriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)this.myDescriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isExcluded() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        return descriptor2 != null && this.getPresentation().isExcluded(descriptor2);
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            return "";
        }
        PsiElement element2 = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        String name = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element2, 4);
        return (String)NAME_INTERNER.intern((Object)name);
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.myDescriptor != null && this.getPresentation().isProblemResolved(this.myDescriptor) && !this.isAlreadySuppressedFromView();
    }

    @Override
    @Nullable
    public String getTailText() {
        String text = super.getTailText();
        return text == null ? "" : text;
    }

    @Override
    @NotNull
    public Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        PsiElement element2 = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null);
        return Pair.create((Object)element2, (Object)descriptor2);
    }
}

