/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTreeModel
extends BaseTreeModel<InspectionTreeNode>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(InspectionTreeModel.class);
    private final InspectionRootNode myRoot = new InspectionRootNode(this);
    private final Invoker myInvoker = ApplicationManager.getApplication().isUnitTestMode() ? Invoker.forEventDispatchThread((Disposable)this) : Invoker.forBackgroundThreadWithReadAction((Disposable)this);

    @Override
    public int getIndexOfChild(Object object, Object child2) {
        return ((InspectionTreeNode)object).getIndex((TreeNode)child2);
    }

    public void reload() {
        this.treeNodesChanged(null, null, null);
    }

    @Override
    public List<? extends InspectionTreeNode> getChildren(Object parent) {
        List<? extends InspectionTreeNode> children2 = ((InspectionTreeNode)parent).getChildren();
        children2.forEach(InspectionTreeNode::uiRequested);
        return children2;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object == this.myRoot) {
            return false;
        }
        return super.isLeaf(object);
    }

    @Override
    public int getChildCount(Object object) {
        return ((InspectionTreeNode)object).getChildren().size();
    }

    public InspectionRootNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public InspectionTreeNode getParent(InspectionTreeNode node) {
        return node.myParent;
    }

    public JBIterable<InspectionTreeNode> traverse(InspectionTreeNode node) {
        return TreeTraversal.PRE_ORDER_DFS.traversal((Object)node, n -> this.getChildren(n));
    }

    @NotNull
    JBIterable<InspectionTreeNode> traverseFrom(InspectionTreeNode node, boolean direction) {
        return JBIterable.generate((Object)node, n -> this.getParent((InspectionTreeNode)n)).filter(n -> this.getParent((InspectionTreeNode)n) != null).flatMap(n1 -> {
            InspectionTreeNode p = this.getParent((InspectionTreeNode)n1);
            int idx = this.getIndexOfChild(p, n1);
            if (idx < 0) {
                return JBIterable.empty();
            }
            assert (p != null);
            InspectionTreeNode.Children children2 = p.myChildren;
            if (children2 == null) {
                return JBIterable.empty();
            }
            InspectionTreeNode[] arr = children2.myChildren;
            List<InspectionTreeNode> sublist = direction ? Arrays.asList(arr).subList(idx + (n1 == node ? 0 : 1), arr.length) : ContainerUtil.reverse(Arrays.asList(arr).subList(0, idx));
            return TreeTraversal.PRE_ORDER_DFS.traversal(sublist, n -> direction ? this.getChildren(n) : ContainerUtil.reverse(this.getChildren(n)));
        });
    }

    public void remove(@NotNull InspectionTreeNode node) {
        this.doRemove(node, null);
        this.treeNodesChanged(null, null, null);
        this.treeStructureChanged(null, null, null);
    }

    private synchronized void doRemove(@NotNull InspectionTreeNode node, @Nullable InspectionTreeNode skip) {
        InspectionTreeNode parent;
        for (InspectionTreeNode inspectionTreeNode : this.getChildren(node)) {
            this.doRemove(inspectionTreeNode, skip);
        }
        if (node != skip && (parent = this.getParent(node)) != null) {
            InspectionTreeNode.Children children2 = parent.myChildren;
            assert (children2 != null);
            children2.myChildren = (InspectionTreeNode[])ArrayUtil.remove((Object[])children2.myChildren, (Object)node);
            children2.myUserObject2Node.removeValue((Object)node);
        }
    }

    synchronized void clearTree() {
        InspectionTreeNode.Children children2 = this.myRoot.myChildren;
        if (children2 != null) {
            children2.clear();
        }
    }

    @NotNull
    public InspectionModuleNode createModuleNode(@NotNull Module module, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(module, () -> new InspectionModuleNode(module, parent), parent);
    }

    @NotNull
    public InspectionPackageNode createPackageNode(String packageName, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(packageName, () -> new InspectionPackageNode(packageName, parent), parent);
    }

    @NotNull
    InspectionGroupNode createGroupNode(String group, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(group, () -> new InspectionGroupNode(group, parent), parent);
    }

    @NotNull
    InspectionSeverityGroupNode createSeverityGroupNode(SeverityRegistrar severityRegistrar, HighlightDisplayLevel level, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(level, () -> new InspectionSeverityGroupNode(severityRegistrar, level, parent), parent);
    }

    @NotNull
    public RefElementNode createRefElementNode(@Nullable RefEntity entity, @NotNull Supplier<? extends RefElementNode> supplier2, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(entity, () -> (RefElementNode)ReadAction.compute(((Supplier)supplier2)::get), parent);
    }

    public <T extends InspectionTreeNode> T createCustomNode(@NotNull Object userObject, @NotNull Supplier<T> supplier2, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(userObject, supplier2, parent);
    }

    @NotNull
    InspectionNode createInspectionNode(@NotNull InspectionToolWrapper toolWrapper, InspectionProfileImpl profile, @NotNull InspectionTreeNode parent) {
        return this.getOrAdd(toolWrapper.getShortName(), () -> new InspectionNode(toolWrapper, profile, parent), parent);
    }

    public void createProblemDescriptorNode(RefEntity element2, @NotNull CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent) {
        this.getOrAdd(descriptor2, () -> (ProblemDescriptionNode)ReadAction.compute(() -> new ProblemDescriptionNode(element2, descriptor2, presentation2, parent)), parent);
    }

    public void createOfflineProblemDescriptorNode(@NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull OfflineDescriptorResolveResult resolveResult, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent) {
        this.getOrAdd(offlineDescriptor, () -> (OfflineProblemDescriptorNode)ReadAction.compute(() -> new OfflineProblemDescriptorNode(resolveResult, presentation2, offlineDescriptor, parent)), parent);
    }

    private synchronized <T extends InspectionTreeNode> T getOrAdd(Object userObject, Supplier<? extends T> supplier2, InspectionTreeNode parent) {
        InspectionTreeNode node;
        InspectionTreeNode.Children children2;
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        if (userObject == null) {
            userObject = ObjectUtils.NULL;
        }
        if ((children2 = parent.myChildren) == null) {
            parent.myChildren = children2 = new InspectionTreeNode.Children();
        }
        if ((node = (InspectionTreeNode)children2.myUserObject2Node.get(userObject)) == null) {
            InspectionTreeNode.Children finalChildren = children2;
            node = (InspectionTreeNode)supplier2.get();
            InspectionTreeNode finalNode = node;
            int idx = (Integer)ReadAction.compute(() -> Arrays.binarySearch(finalChildren.myChildren, finalNode, InspectionResultsViewComparator.INSTANCE));
            int insertionPoint = idx >= 0 ? idx : -idx - 1;
            children2.myChildren = (InspectionTreeNode[])ArrayUtil.insert((Object[])children2.myChildren, (int)insertionPoint, (Object)node);
            children2.myUserObject2Node.put(userObject, (Object)node);
            LOG.assertTrue(children2.myChildren.length == children2.myUserObject2Node.size());
            if (node instanceof SuppressableInspectionTreeNode) {
                ((SuppressableInspectionTreeNode)node).nodeAdded();
            }
            TreePath path = TreePathUtil.pathToTreeNode(node);
            TreePath parentPath = path.getParentPath();
            this.treeNodesInserted(parentPath, null, null);
            while (parentPath != null) {
                this.treeStructureChanged(parentPath, null, null);
                if ((parentPath = parentPath.getParentPath()) != null && parentPath.getLastPathComponent() != this.myRoot) continue;
                break;
            }
        }
        return (T)node;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.myInvoker;
    }
}

