/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    private final InspectionTreeModel myModel;
    private boolean myQueueUpdate;
    private final OccurenceNavigator myOccurenceNavigator = new MyOccurrenceNavigator();
    private final InspectionResultsView myView;

    public InspectionTree(@NotNull InspectionResultsView view) {
        this.myView = view;
        this.myModel = new InspectionTreeModel();
        Disposer.register((Disposable)view, (Disposable)this.myModel);
        this.setModel((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myModel), false, view)));
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(false);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getSelectionModel().addTreeSelectionListener(e -> {
                if (this.isUnderQueueUpdate()) {
                    return;
                }
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                    if (this.myView.isAutoScrollMode()) {
                        OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), (boolean)false);
                    }
                }
            });
            EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
            EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
            TreeUtil.installActions((JTree)((Object)this));
            PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"InspectionToolWindow.TreePopup", (String)"CodeInspection");
            new TreeSpeedSearch(this, (Convertor<? super TreePath, String>)((Convertor)o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString())));
        }
        this.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
            boolean myAlreadyDone;

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (!this.myAlreadyDone && InspectionTree.this.getSelectionCount() == 0) {
                    this.myAlreadyDone = true;
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        InspectionTree.this.expandPath(new TreePath(InspectionTree.this.myModel.getRoot()));
                        SmartExpander.installOn((JTree)((Object)InspectionTree.this));
                        if (!InspectionTree.this.myView.isDisposed()) {
                            InspectionTree.this.myView.syncRightPanel();
                        }
                    });
                }
            }
        });
    }

    public InspectionTreeNode getRoot() {
        return this.myModel.getRoot();
    }

    public InspectionTreeModel getInspectionTreeModel() {
        return this.myModel;
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    public boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    public void removeAllNodes() {
        this.myModel.clearTree();
    }

    public String @Nullable [] getSelectedGroupPath() {
        TreePath commonPath = TreePathUtil.findCommonAncestor(this.getSelectionPaths());
        if (commonPath == null) {
            return null;
        }
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return InspectionTree.getGroupPath((InspectionGroupNode)n);
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper(boolean allowDummy) {
        InspectionProfileImpl profile = this.myView.getCurrentProfile();
        String singleToolName = profile.getSingleTool();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (singleToolName != null) {
                InspectionToolWrapper tool = profile.getInspectionTool(singleToolName, this.myView.getProject());
                LOG.assertTrue(tool != null);
                return tool;
            }
            return null;
        }
        InspectionToolWrapper resultWrapper = null;
        block0: for (TreePath path : paths) {
            Object[] nodes = path.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node = nodes[j];
                if (node instanceof InspectionGroupNode) {
                    return null;
                }
                InspectionToolWrapper wrapper2 = null;
                if (node instanceof InspectionNode) {
                    wrapper2 = ((InspectionNode)node).getToolWrapper();
                } else if (node instanceof SuppressableInspectionTreeNode) {
                    wrapper2 = ((SuppressableInspectionTreeNode)node).getPresentation().getToolWrapper();
                }
                if (wrapper2 == null || !allowDummy && this.getContext().getPresentation(wrapper2).isDummy()) continue;
                if (resultWrapper == null) {
                    resultWrapper = wrapper2;
                    continue block0;
                }
                if (resultWrapper == wrapper2) continue block0;
                return null;
            }
        }
        if (resultWrapper == null && singleToolName != null) {
            InspectionToolWrapper tool = profile.getInspectionTool(singleToolName, this.myView.getProject());
            LOG.assertTrue(tool != null);
            return tool;
        }
        return resultWrapper;
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        Object lastComponent = path.getLastPathComponent();
        if (!(lastComponent instanceof ProblemDescriptionNode)) {
            return null;
        }
        return ((ProblemDescriptionNode)lastComponent).getToolTipText();
    }

    @Nullable
    public RefEntity getCommonSelectedElement() {
        Object node = this.getCommonSelectedNode();
        return node instanceof RefElementNode ? ((RefElementNode)node).getElement() : null;
    }

    @Nullable
    private Object getCommonSelectedNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        Object[][] resolvedPaths = new Object[paths.length][];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            TreePath path = paths[i2];
            resolvedPaths[i2] = path.getPath();
        }
        Object currentCommonNode = null;
        for (int i3 = 0; i3 < resolvedPaths[0].length; ++i3) {
            Object currentNode = resolvedPaths[0][i3];
            for (int j = 1; j < resolvedPaths.length; ++j) {
                Object o = resolvedPaths[j][i3];
                if (o.equals(currentNode)) continue;
                return currentCommonNode;
            }
            currentCommonNode = currentNode;
        }
        return currentCommonNode;
    }

    public RefEntity @NotNull [] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet result2 = new LinkedHashSet();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node, result2);
            }
            return (RefEntity[])ArrayUtil.reverseArray((Object[])result2.toArray(RefEntity.EMPTY_ELEMENTS_ARRAY));
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    public OccurenceNavigator getOccurenceNavigator() {
        return this.myOccurenceNavigator;
    }

    public void selectNode(InspectionTreeNode node) {
        TreePath path = this.getPathFor(node);
        TreeUtil.selectPath((JTree)((Object)this), (TreePath)path);
    }

    private static void addElementsInNode(InspectionTreeNode node, Set<? super RefEntity> out) {
        if (!node.isValid()) {
            return;
        }
        if (node instanceof RefElementNode) {
            RefEntity element2 = ((RefElementNode)node).getElement();
            out.add((RefEntity)element2);
        }
        if (node instanceof ProblemDescriptionNode) {
            RefEntity element2 = ((ProblemDescriptionNode)node).getElement();
            out.add((RefEntity)element2);
        }
        for (InspectionTreeNode inspectionTreeNode : node.getChildren()) {
            InspectionTree.addElementsInNode(inspectionTreeNode, out);
        }
    }

    public CommonProblemDescriptor @NotNull [] getAllValidSelectedDescriptors() {
        return BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, true, null));
    }

    public CommonProblemDescriptor @NotNull [] getSelectedDescriptors() {
        return BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, false, null));
    }

    @NotNull
    public List<CommonProblemDescriptor[]> getSelectedDescriptorPacks(boolean sortedByPosition, @Nullable Set<? super VirtualFile> readOnlyFilesSink, boolean allowResolved, TreePath[] paths) {
        if (paths == null) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            paths = this.getSelectionPaths();
        }
        if (paths == null) {
            return Collections.emptyList();
        }
        MultiMap parentToChildNode = new MultiMap();
        TreeTraversal.PLAIN_BFS.traversal((Iterable)ContainerUtil.map((Object[])paths, p -> (InspectionTreeNode)p.getLastPathComponent()), n -> this.myModel.getChildren(n)).filter(ProblemDescriptionNode.class).filter(node -> node.getDescriptor() != null && InspectionTree.isNodeValidAndIncluded(node, allowResolved)).consumeEach(node -> {
            Object key = InspectionTree.getVirtualFileOrEntity(node.getElement());
            parentToChildNode.putValue(key, (Object)node.getDescriptor());
        });
        ArrayList<CommonProblemDescriptor[]> descriptors = new ArrayList<CommonProblemDescriptor[]>();
        for (Map.Entry entry : parentToChildNode.entrySet()) {
            Object key = entry.getKey();
            if (readOnlyFilesSink != null && key instanceof VirtualFile && !((VirtualFile)key).isWritable()) {
                readOnlyFilesSink.add((VirtualFile)((VirtualFile)key));
            }
            Stream stream = ((Collection)entry.getValue()).stream();
            if (sortedByPosition) {
                stream = stream.sorted(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.add((CommonProblemDescriptor[])stream.toArray(arg_0 -> ((ArrayFactory)CommonProblemDescriptor.ARRAY_FACTORY).create(arg_0)));
        }
        return descriptors;
    }

    public TreePath @Nullable [] getSelectionPaths() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return super.getSelectionPaths();
    }

    @NotNull
    InspectionTreeNode getToolProblemsRootNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionTreeNode parent = this.getToolParentNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        if (isSingleInspectionRun) {
            return parent;
        }
        return this.myModel.createInspectionNode(toolWrapper, this.myView.getCurrentProfile(), parent);
    }

    @NotNull
    private InspectionTreeNode getToolParentNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionTreeNode currentNode;
        if (!groupedBySeverity && isSingleInspectionRun) {
            return this.myModel.getRoot();
        }
        InspectionTreeNode inspectionTreeNode = currentNode = groupedBySeverity ? this.myModel.createSeverityGroupNode(this.myView.getCurrentProfile().getProfileManager().getSeverityRegistrar(), errorLevel, this.myModel.getRoot()) : this.myModel.getRoot();
        if (isSingleInspectionRun) {
            return currentNode;
        }
        String[] groupPath = toolWrapper.getGroupPath();
        if (groupPath.length == 0) {
            LOG.error("groupPath is empty for tool: " + toolWrapper.getShortName() + ", class: " + toolWrapper.getTool().getClass());
        }
        for (String subGroup : groupPath) {
            currentNode = this.myModel.createGroupNode(subGroup, currentNode);
        }
        return currentNode;
    }

    public boolean areDescriptorNodesSelected() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            if (path.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    public int getSelectedProblemCount() {
        int count = 0;
        for (TreePath path : TreeCollector.TreePathRoots.collect((TreePath[])this.getSelectionPaths())) {
            LevelAndCount[] levels;
            for (LevelAndCount level : levels = ((InspectionTreeNode)path.getLastPathComponent()).getProblemLevels()) {
                count += level.getCount();
            }
        }
        return count;
    }

    private static boolean isNodeValidAndIncluded(ProblemDescriptionNode node, boolean allowResolved) {
        return node.isValid() && (allowResolved || !node.isExcluded() && !node.isAlreadySuppressedFromView() && !node.isQuickFixAppliedFromView());
    }

    public void removeSelectedProblems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] selected2 = this.getSelectionPaths();
        if (selected2 == null) {
            return;
        }
        if (!this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            for (TreePath path : selected2) {
                InspectionTreeNode node = (InspectionTreeNode)path.getLastPathComponent();
                this.myModel.traverse(node).forEach(InspectionTreeNode::dropProblemCountCaches);
            }
            return;
        }
        THashSet processedNodes = new THashSet();
        ArrayList<InspectionTreeNode> toRemove2 = new ArrayList<InspectionTreeNode>();
        ArrayList<TreePath> pathsToSelect = new ArrayList<TreePath>();
        block1: for (TreePath path : selected2) {
            Object[] nodePath = path.getPath();
            for (int i2 = 1; i2 < nodePath.length; ++i2) {
                InspectionTreeNode node = (InspectionTreeNode)nodePath[i2];
                if (!processedNodes.add(node) || !this.shouldDelete(node)) continue;
                toRemove2.add(node);
                TreePath toSelect2 = InspectionTree.getParentPath(path, nodePath.length - i2);
                if (toSelect2 == null) continue block1;
                pathsToSelect.add(toSelect2);
                continue block1;
            }
        }
        if (toRemove2.isEmpty()) {
            return;
        }
        THashSet parents2 = new THashSet();
        for (InspectionTreeNode node : toRemove2) {
            InspectionTreeNode parent = node.getParent();
            if (parent == null) continue;
            this.myModel.remove(node);
            parents2.add(parent);
        }
        for (InspectionTreeNode parent : parents2) {
            parent.dropProblemCountCaches();
        }
        TreePath commonPath = TreePathUtil.findCommonAncestor(pathsToSelect);
        if (commonPath != null) {
            TreeUtil.selectPath((JTree)((Object)this), (TreePath)commonPath);
        }
        this.revalidate();
        this.repaint();
    }

    private static TreePath getParentPath(TreePath path, int ord) {
        TreePath parent = path;
        for (int j = 0; j < ord; ++j) {
            parent = parent.getParentPath();
        }
        return parent;
    }

    private boolean shouldDelete(InspectionTreeNode node) {
        if (node instanceof RefElementNode) {
            RefElementNode refElementNode = (RefElementNode)node;
            InspectionToolPresentation presentation2 = refElementNode.getPresentation();
            RefEntity element2 = refElementNode.getElement();
            if (element2 == null || presentation2.isProblemResolved(element2) || presentation2.isExcluded(element2) || presentation2.isSuppressed(element2)) {
                return true;
            }
            List<? extends InspectionTreeNode> children2 = node.getChildren();
            return !children2.isEmpty() && children2.stream().allMatch(this::shouldDelete);
        }
        if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemDescriptionNode = (ProblemDescriptionNode)node;
            CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
            InspectionToolPresentation presentation3 = problemDescriptionNode.getPresentation();
            if (descriptor2 == null || presentation3.isExcluded(descriptor2) || presentation3.isProblemResolved(descriptor2)) {
                return true;
            }
        } else {
            if (node instanceof InspectionGroupNode || node instanceof InspectionSeverityGroupNode || node instanceof InspectionModuleNode || node instanceof InspectionPackageNode) {
                return node.getChildren().stream().allMatch(this::shouldDelete);
            }
            if (node instanceof InspectionNode) {
                InspectionToolPresentation presentation4 = this.myView.getGlobalInspectionContext().getPresentation(((InspectionNode)node).getToolWrapper());
                SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation4.getProblemElements();
                if (problemElements.isEmpty()) {
                    return true;
                }
                return problemElements.keys().stream().allMatch(entity -> presentation4.isExcluded((RefEntity)entity));
            }
        }
        return false;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        return this.myView.getGlobalInspectionContext();
    }

    private static String @NotNull [] getGroupPath(@NotNull InspectionGroupNode node) {
        InspectionTreeNode parent;
        ArrayList<String> path = new ArrayList<String>(2);
        while ((parent = node.getParent()) instanceof InspectionGroupNode) {
            node = (InspectionGroupNode)parent;
            path.add(node.getSubGroup());
        }
        return ArrayUtilRt.toStringArray(path);
    }

    @Nullable
    private static Object getVirtualFileOrEntity(@Nullable RefEntity entity) {
        VirtualFile file2;
        SmartPsiElementPointer pointer;
        if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (file2 = pointer.getVirtualFile()) != null) {
            return file2;
        }
        return entity;
    }

    private TreePath getPathFor(InspectionTreeNode node) {
        TreePath result2 = TreePathUtil.pathToTreeNode(node);
        Stack s = new Stack();
        for (TreePath current2 = result2; current2 != null; current2 = current2.getParentPath()) {
            s.add((Object)current2);
        }
        while (!s.isEmpty()) {
            TreePath p = (TreePath)s.pop();
            this.expandPath(p);
        }
        return result2;
    }

    private class MyOccurrenceNavigator
    implements OccurenceNavigator {
        private MyOccurrenceNavigator() {
        }

        public boolean hasNextOccurence() {
            return this.getNextNode(true) != null;
        }

        public boolean hasPreviousOccurence() {
            return this.getNextNode(false) != null;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            InspectionTreeNode node = this.getNextNode(true);
            if (node == null) {
                return null;
            }
            InspectionTree.this.selectNode(node);
            return new OccurenceNavigator.OccurenceInfo(this.createDescriptorForNode(node), -1, -1);
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            InspectionTreeNode node = this.getNextNode(false);
            InspectionTree.this.selectNode(node);
            return node == null ? null : new OccurenceNavigator.OccurenceInfo(this.createDescriptorForNode(node), -1, -1);
        }

        @NotNull
        public String getNextOccurenceActionName() {
            return InspectionsBundle.message((String)"inspection.action.go.next", (Object[])new Object[0]);
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            return InspectionsBundle.message((String)"inspection.action.go.prev", (Object[])new Object[0]);
        }

        private InspectionTreeNode getNextNode(boolean next) {
            InspectionTreeNode node = this.getSelectedNode();
            if (node == null) {
                return null;
            }
            return (InspectionTreeNode)InspectionTree.this.myModel.traverseFrom(node, next).filter(n -> n != node).filter(n -> this.isOccurrenceNode((InspectionTreeNode)n)).first();
        }

        private InspectionTreeNode getSelectedNode() {
            TreePath path = InspectionTree.this.getSelectionPath();
            if (path == null) {
                return null;
            }
            return (InspectionTreeNode)path.getLastPathComponent();
        }

        private boolean isOccurrenceNode(@NotNull InspectionTreeNode node) {
            if (node.isExcluded()) {
                return false;
            }
            if (node instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node;
                if (this.hasDescriptorUnder(refNode)) {
                    return false;
                }
                RefEntity element2 = refNode.getElement();
                return element2 != null && element2.isValid();
            }
            return node instanceof ProblemDescriptionNode;
        }

        @Nullable
        private Navigatable createDescriptorForNode(@NotNull InspectionTreeNode node) {
            if (node.isExcluded()) {
                return null;
            }
            if (node instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node;
                if (this.hasDescriptorUnder(refNode)) {
                    return null;
                }
                RefEntity element2 = refNode.getElement();
                if (element2 == null || !element2.isValid()) {
                    return null;
                }
                if (element2 instanceof RefElement) {
                    return this.getOpenFileDescriptor((RefElement)element2);
                }
            } else if (node instanceof ProblemDescriptionNode) {
                ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                boolean isValid = problemNode.isValid() && (!problemNode.isQuickFixAppliedFromView() || problemNode.calculateIsValid());
                return isValid ? this.navigate(problemNode.getDescriptor()) : InspectionResultsViewUtil.getNavigatableForInvalidNode(problemNode);
            }
            return null;
        }

        @Nullable
        private Navigatable navigate(CommonProblemDescriptor descriptor2) {
            return InspectionResultsView.getSelectedNavigatable(descriptor2);
        }

        @Nullable
        private Navigatable getOpenFileDescriptor(RefElement refElement) {
            PsiElement psiElement = refElement.getPsiElement();
            if (psiElement == null) {
                return null;
            }
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 == null) {
                return null;
            }
            return PsiNavigationSupport.getInstance().createNavigatable(refElement.getRefManager().getProject(), file2, psiElement.getTextOffset());
        }

        private boolean hasDescriptorUnder(RefElementNode node) {
            InspectionTreeNode current2 = node;
            while (current2 != null && current2.getChildCount() != 0) {
                if (!((current2 = current2.getChildAt(0)) instanceof ProblemDescriptionNode)) continue;
                return true;
            }
            return false;
        }
    }
}

