/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    public static final ExtensionPointName<RefGraphAnnotator> EP_NAME = ExtensionPointName.create((String)"com.intellij.refGraphAnnotator");
    private static final Logger LOG = Logger.getInstance(RefManager.class);
    private long myLastUsedMask = 0x8000000L;
    @NotNull
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private final BitSet myUnprocessedFiles = new BitSet();
    private final boolean processExternalElements = Registry.is((String)"batch.inspections.process.external.elements");
    private final ConcurrentMap<PsiAnchor, RefElement> myRefTable = new ConcurrentHashMap<PsiAnchor, RefElement>();
    private volatile List<RefElement> myCachedSortedRefs;
    private final ConcurrentMap<Module, RefModule> myModules = new ConcurrentHashMap<Module, RefModule>();
    private final ProjectIterator myProjectIterator = new ProjectIterator();
    private final AtomicBoolean myDeclarationsFound = new AtomicBoolean(false);
    private final PsiManager myPsiManager;
    private volatile boolean myIsInProcess;
    private volatile boolean myOfflineView;
    private final List<RefGraphAnnotator> myGraphAnnotators = ContainerUtil.createConcurrentList();
    private GlobalInspectionContext myContext;
    private final Map<Key, RefManagerExtension> myExtensions = new THashMap();
    private final Map<Language, RefManagerExtension> myLanguageExtensions = new HashMap<Language, RefManagerExtension>();
    private final Interner<String> myNameInterner = Interner.createStringInterner();

    public RefManagerImpl(@NotNull Project project, @Nullable AnalysisScope scope, @NotNull GlobalInspectionContext context) {
        this.myProject = project;
        this.myScope = scope;
        this.myContext = context;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myRefProject = new RefProjectImpl(this);
        for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            RefManagerExtension extension = factory2.createRefManagerExtension((RefManager)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            for (Language language : extension.getLanguages()) {
                this.myLanguageExtensions.put(language, extension);
            }
        }
        if (scope != null) {
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                this.getRefModule(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String internName(@NotNull String name) {
        Interner<String> interner = this.myNameInterner;
        synchronized (interner) {
            return (String)this.myNameInterner.intern((Object)name);
        }
    }

    @NotNull
    public GlobalInspectionContext getContext() {
        return this.myContext;
    }

    public void iterate(@NotNull RefVisitor visitor) {
        for (RefElement refElement : this.getSortedElements()) {
            refElement.accept(visitor);
        }
        for (RefModule refModule : this.myModules.values()) {
            if (!this.myScope.containsModule(refModule.getModule())) continue;
            refModule.accept(visitor);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.iterate(visitor);
        }
    }

    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        this.myRefTable.clear();
        this.myCachedSortedRefs = null;
        this.myModules.clear();
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        this.myExtensions.clear();
        this.myLanguageExtensions.clear();
    }

    @Nullable
    public AnalysisScope getScope() {
        return this.myScope;
    }

    private void fireNodeInitialized(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onInitialize(refElement);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement element2) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting, element2);
        }
    }

    public void fireNodeMarkedReferenced(PsiElement what, PsiElement from) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(what, from, false);
        }
    }

    public void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(@NotNull RefGraphAnnotator annotator) {
        if (!this.myGraphAnnotators.contains(annotator)) {
            this.myGraphAnnotators.add(annotator);
            if (annotator instanceof RefGraphAnnotatorEx) {
                ((RefGraphAnnotatorEx)annotator).initialize((RefManager)this);
            }
        }
    }

    public void unregisterAnnotator(RefGraphAnnotator annotator) {
        this.myGraphAnnotators.remove(annotator);
    }

    public synchronized long getLastUsedMask() {
        if (this.myLastUsedMask < 0L) {
            throw new IllegalStateException("We're out of 64 bits, sorry");
        }
        this.myLastUsedMask *= 2L;
        return this.myLastUsedMask;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    @Nullable
    public String getType(@NotNull RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String type = extension.getType(ref);
            if (type == null) continue;
            return type;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            ref = extension.getRefinedElement(ref);
        }
        return ref;
    }

    @Nullable
    public Element export(@NotNull RefEntity refEntity, int actualLine) {
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefDirectory) {
            Element fileElement = new Element("file");
            VirtualFile virtualFile = ((PsiDirectory)((RefDirectory)refEntity).getPsiElement()).getVirtualFile();
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
        } else if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            SmartPsiElementPointer pointer = refElement.getPointer();
            PsiFile psiFile = pointer.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            Element fileElement = new Element("file");
            Element lineElement = new Element("line");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)pointer.getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                Segment range2 = pointer.getRange();
                lineElement.addContent(String.valueOf(range2 != null ? document.getLineNumber(range2.getStartOffset()) + 1 : -1));
            } else {
                lineElement.addContent(String.valueOf(actualLine + 1));
            }
            problem.addContent(fileElement);
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        return problem;
    }

    @Nullable
    public String getGroupName(@NotNull RefElement entity) {
        RefEntity parent;
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String groupName = extension.getGroupName((RefEntity)entity);
            if (groupName == null) continue;
            return groupName;
        }
        for (parent = entity.getOwner(); parent != null && !(parent instanceof RefDirectory); parent = parent.getOwner()) {
        }
        LinkedList<String> containingDirs = new LinkedList<String>();
        while (parent instanceof RefDirectory) {
            containingDirs.addFirst(parent.getName());
            parent = parent.getOwner();
        }
        return containingDirs.isEmpty() ? null : StringUtil.join(containingDirs, (String)File.separator);
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        if (!this.myDeclarationsFound.getAndSet(true)) {
            long before = System.currentTimeMillis();
            AnalysisScope scope = this.getScope();
            if (scope != null) {
                scope.accept((PsiElementVisitor)this.myProjectIterator);
            }
            LOG.info("Total duration of processing project usages:" + (System.currentTimeMillis() - before));
        }
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound.get();
    }

    public void inspectionReadActionStarted() {
        this.myIsInProcess = true;
    }

    public void inspectionReadActionFinished() {
        this.myIsInProcess = false;
        if (this.myScope != null) {
            this.myScope.invalidate();
        }
        this.myCachedSortedRefs = null;
    }

    public void startOfflineView() {
        this.myOfflineView = true;
    }

    public boolean isOfflineView() {
        return this.myOfflineView;
    }

    public boolean isInProcess() {
        return this.myIsInProcess;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public RefProject getRefProject() {
        return this.myRefProject;
    }

    @NotNull
    public List<RefElement> getSortedElements() {
        List<RefElement> answer = this.myCachedSortedRefs;
        if (answer != null) {
            return answer;
        }
        List<RefElement> list2 = answer = new ArrayList(this.myRefTable.values());
        ReadAction.run(() -> ContainerUtil.quickSort((List)list2, (o1, o2) -> {
            VirtualFile v1 = ((RefElementImpl)o1).getVirtualFile();
            VirtualFile v2 = ((RefElementImpl)o2).getVirtualFile();
            return (v1 != null ? v1.hashCode() : 0) - (v2 != null ? v2.hashCode() : 0);
        }));
        this.myCachedSortedRefs = answer = Collections.unmodifiableList(answer);
        return answer;
    }

    @NotNull
    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    public synchronized boolean isInGraph(VirtualFile file2) {
        return !this.myUnprocessedFiles.get(((VirtualFileWithId)file2).getId());
    }

    @Nullable
    public PsiNamedElement getContainerElement(@NotNull PsiElement element2) {
        Language language = element2.getLanguage();
        RefManagerExtension extension = this.myLanguageExtensions.get(language);
        if (extension == null) {
            return null;
        }
        return extension.getElementContainer(element2);
    }

    private synchronized void registerUnprocessed(VirtualFileWithId virtualFile) {
        this.myUnprocessedFiles.set(virtualFile.getId());
    }

    void removeReference(@NotNull RefElement refElem) {
        RefManagerExtension extension;
        PsiElement element2 = refElem.getPsiElement();
        RefManagerExtension refManagerExtension = extension = element2 != null ? this.getExtension(element2.getLanguage()) : null;
        if (extension != null) {
            extension.removeReference(refElem);
        }
        if (element2 != null && this.myRefTable.remove(RefManagerImpl.createAnchor(element2)) != null) {
            return;
        }
        for (Map.Entry entry : this.myRefTable.entrySet()) {
            RefElement value2 = (RefElement)entry.getValue();
            PsiAnchor anchor2 = (PsiAnchor)entry.getKey();
            if (value2 != refElem) continue;
            this.myRefTable.remove(anchor2);
            break;
        }
        this.myCachedSortedRefs = null;
    }

    @NotNull
    private static PsiAnchor createAnchor(@NotNull PsiElement element2) {
        return (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create(element2));
    }

    public void initializeAnnotators() {
        for (RefGraphAnnotator annotator : EP_NAME.getExtensionList()) {
            this.registerGraphAnnotator(annotator);
        }
    }

    @Nullable
    public RefElement getReference(@Nullable PsiElement elem) {
        return this.getReference(elem, false);
    }

    @Nullable
    public RefElement getReference(PsiElement elem, boolean ignoreScope) {
        if (((Boolean)ReadAction.compute(() -> elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !this.belongsToScope(elem, ignoreScope))).booleanValue()) {
            return null;
        }
        return this.getFromRefTableOrCache(elem, () -> (RefElementImpl)ReadAction.compute(() -> {
            RefElement refElement;
            RefManagerExtension extension = this.getExtension(elem.getLanguage());
            if (extension != null && (refElement = extension.createRefElement(elem)) != null) {
                return (RefElementImpl)refElement;
            }
            if (elem instanceof PsiFile) {
                return new RefFileImpl((PsiFile)elem, (RefManager)this);
            }
            if (elem instanceof PsiDirectory) {
                return new RefDirectoryImpl((PsiDirectory)elem, (RefManager)this);
            }
            return null;
        }), element2 -> ReadAction.run(() -> {
            element2.initialize();
            for (RefManagerExtension each : this.myExtensions.values()) {
                each.onEntityInitialized((RefElement)element2, elem);
            }
            this.fireNodeInitialized((RefElement)element2);
        }));
    }

    private RefManagerExtension getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            RefEntity refEntity = extension.getReference(type, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type)) {
            return this.getRefProject();
        }
        if ("dir".equals(type)) {
            String url = VfsUtilCore.pathToUrl((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(fqName));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                PsiDirectory dir = PsiManager.getInstance((Project)this.getProject()).findDirectory(vFile);
                return this.getReference((PsiElement)dir);
            }
        }
        return null;
    }

    @Nullable
    public <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element2, @NotNull NullableFactory<? extends T> factory2) {
        return this.getFromRefTableOrCache(element2, factory2, null);
    }

    @Nullable
    private <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element2, @NotNull NullableFactory<? extends T> factory2, @Nullable Consumer<? super T> whenCached) {
        PsiAnchor psiAnchor = RefManagerImpl.createAnchor(element2);
        RefElement result2 = (RefElement)this.myRefTable.get(psiAnchor);
        if (result2 != null) {
            return (T)result2;
        }
        if (!this.isValidPointForReference()) {
            return null;
        }
        result2 = (RefElement)factory2.create();
        if (result2 == null) {
            return null;
        }
        this.myCachedSortedRefs = null;
        RefElement prev = this.myRefTable.putIfAbsent(psiAnchor, result2);
        if (prev != null) {
            result2 = prev;
        } else if (whenCached != null) {
            whenCached.consume((Object)result2);
        }
        return (T)result2;
    }

    public RefModule getRefModule(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        RefModule refModule = (RefModule)this.myModules.get(module);
        if (refModule == null) {
            refModule = (RefModule)ConcurrencyUtil.cacheOrGet(this.myModules, (Object)module, (Object)new RefModuleImpl(module, (RefManager)this));
        }
        return refModule;
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return this.belongsToScope(psiElement, false);
    }

    private boolean belongsToScope(PsiElement psiElement, boolean ignoreScope) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiElement)psiElement).getContainingFile());
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            if (extension.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = (Boolean)ReadAction.compute(() -> psiElement.getManager().isInProject(psiElement));
        return inProject != false && (ignoreScope || this.getScope() == null || this.getScope().contains(psiElement));
    }

    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return AnalysisBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    public void removeRefElement(@NotNull RefElement refElement, @NotNull List<RefElement> deletedRefs) {
        RefElement[] refElements;
        List children2 = refElement.getChildren();
        for (RefElement refChild : refElements = children2.toArray(new RefElement[0])) {
            this.removeRefElement(refChild, deletedRefs);
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add(refElement);
        } else {
            LOG.error("deleted second time");
        }
    }

    public boolean isValidPointForReference() {
        return this.myIsInProcess || this.myOfflineView || ApplicationManager.getApplication().isUnitTestMode();
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        public void visitElement(@NotNull PsiElement element2) {
            PsiFile file2;
            ProgressManager.checkCanceled();
            RefManagerExtension extension = RefManagerImpl.this.getExtension(element2.getLanguage());
            if (extension != null) {
                extension.visitElement(element2);
            } else if (RefManagerImpl.this.processExternalElements && (file2 = element2.getContainingFile()) != null) {
                RefManagerExtension externalFileManagerExtension = RefManagerImpl.this.myExtensions.values().stream().filter(ex -> ex.shouldProcessExternalFile(file2)).findFirst().orElse(null);
                if (externalFileManagerExtension == null) {
                    VirtualFile virtualFile;
                    if (element2 instanceof PsiFile && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2)) instanceof VirtualFileWithId) {
                        RefManagerImpl.this.registerUnprocessed((VirtualFileWithId)virtualFile);
                    }
                } else {
                    RefElement refFile = RefManagerImpl.this.getReference((PsiElement)file2);
                    LOG.assertTrue(refFile != null, (Object)file2);
                    for (PsiReference reference2 : element2.getReferences()) {
                        PsiElement resolve2 = reference2.resolve();
                        if (resolve2 == null) continue;
                        RefManagerImpl.this.fireNodeMarkedReferenced(resolve2, (PsiElement)file2);
                        RefElement refWhat = RefManagerImpl.this.getReference(resolve2);
                        if (refWhat == null) {
                            PsiFile targetContainingFile = resolve2.getContainingFile();
                            if (file2 == targetContainingFile) continue;
                            refWhat = RefManagerImpl.this.getReference((PsiElement)targetContainingFile);
                        }
                        if (refWhat == null) continue;
                        ((RefElementImpl)refWhat).addInReference(refFile);
                        ((RefElementImpl)refFile).addOutReference(refWhat);
                    }
                    Stream implicitRefs = externalFileManagerExtension.extractExternalFileImplicitReferences(file2);
                    implicitRefs.forEach(e -> {
                        RefElement superClassReference = RefManagerImpl.this.getReference((PsiElement)e);
                        if (superClassReference != null) {
                            ((RefElementImpl)refFile).addOutReference(superClassReference);
                        }
                    });
                    if (element2 instanceof PsiFile) {
                        externalFileManagerExtension.markExternalReferencesProcessed(refFile);
                    }
                }
            }
            for (PsiElement aChildren : element2.getChildren()) {
                aChildren.accept((PsiElementVisitor)this);
            }
        }

        public void visitFile(@NotNull PsiFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                String relative = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)RefManagerImpl.this.myProject, (boolean)true, (boolean)false);
                RefManagerImpl.this.myContext.incrementJobDoneAmount(((RefManagerImpl)RefManagerImpl.this).myContext.getStdJobDescriptors().BUILD_GRAPH, relative);
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                try {
                    this.visitElement((PsiElement)viewProvider.getPsi(language));
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error((Throwable)new RuntimeExceptionWithAttachments(e, new Attachment[]{new Attachment("diagnostics.txt", file2.getName())}));
                }
            }
            RefManagerImpl.this.myPsiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance((Project)RefManagerImpl.this.myProject).dropFileCaches(file2);
        }
    }
}

