/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionToolWrapper
extends InspectionToolWrapper<LocalInspectionTool, LocalInspectionEP> {
    public LocalInspectionToolWrapper(@NotNull LocalInspectionTool tool) {
        super((InspectionProfileEntry)tool, (InspectionEP)LocalInspectionEP.LOCAL_INSPECTION.getByKey((Object)tool.getShortName(), LocalInspectionToolWrapper.class, InspectionEP::getShortName));
    }

    public LocalInspectionToolWrapper(@NotNull LocalInspectionEP ep2) {
        super((InspectionEP)ep2);
    }

    private LocalInspectionToolWrapper(@NotNull LocalInspectionToolWrapper other) {
        super((InspectionToolWrapper)other);
    }

    @NotNull
    public LocalInspectionToolWrapper createCopy() {
        return new LocalInspectionToolWrapper(this);
    }

    public JobDescriptor @NotNull [] getJobDescriptors(@NotNull GlobalInspectionContext context) {
        return context.getStdJobDescriptors().LOCAL_ANALYSIS_ARRAY;
    }

    public boolean isUnfair() {
        return this.myEP == null ? this.getTool() instanceof UnfairLocalInspectionTool : ((LocalInspectionEP)this.myEP).unfair;
    }

    public boolean isDynamicGroup() {
        return this.myEP == null ? this.getTool() instanceof DynamicGroupTool : ((LocalInspectionEP)this.myEP).dynamicGroup;
    }

    public String getID() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).getID() : (((LocalInspectionEP)this.myEP).id == null ? ((LocalInspectionEP)this.myEP).getShortName() : ((LocalInspectionEP)this.myEP).id);
    }

    @Nullable
    public String getAlternativeID() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).getAlternativeID() : ((LocalInspectionEP)this.myEP).alternativeId;
    }

    public boolean runForWholeFile() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).runForWholeFile() : ((LocalInspectionEP)this.myEP).runForWholeFile;
    }

    @Nullable
    public static InspectionToolWrapper<?, ?> findTool2RunInBatch(@NotNull Project project, @Nullable PsiElement element2, @NotNull String name) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        InspectionToolWrapper toolWrapper = element2 == null ? inspectionProfile.getInspectionTool(name, project) : inspectionProfile.getInspectionTool(name, element2);
        return LocalInspectionToolWrapper.findTool2RunInBatch(project, element2, inspectionProfile, toolWrapper);
    }

    @Nullable
    public static InspectionToolWrapper<?, ?> findTool2RunInBatch(@NotNull Project project, @Nullable PsiElement element2, @NotNull InspectionProfile inspectionProfile, @Nullable InspectionToolWrapper<?, ?> toolWrapper) {
        if (toolWrapper instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)toolWrapper).isUnfair()) {
            LocalInspectionTool inspectionTool = (LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool();
            if (inspectionTool instanceof PairedUnfairLocalInspectionTool) {
                String oppositeShortName = ((PairedUnfairLocalInspectionTool)inspectionTool).getInspectionForBatchShortName();
                return element2 == null ? inspectionProfile.getInspectionTool(oppositeShortName, project) : inspectionProfile.getInspectionTool(oppositeShortName, element2);
            }
            return null;
        }
        return toolWrapper;
    }
}

