/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.serviceContainer.NonInjectable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml")}, additionalExportFile="inspection")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0017\u0018\u0000 \u001c2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u001cB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager;", "Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManagerBase;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "schemeManagerFactory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "(Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "converter", "Lcom/intellij/codeInsight/daemon/InspectionProfileConvertor;", "getConverter", "()Lcom/intellij/codeInsight/daemon/InspectionProfileConvertor;", "rootProfileName", "", "getRootProfileName", "()Ljava/lang/String;", "fireProfileChanged", "", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "forceInitProfiles", "flag", "", "getState", "loadProfile", "path", "loadState", "state", "Companion", "intellij.platform.lang.impl"})
public class ApplicationInspectionProfileManager
extends ApplicationInspectionProfileManagerBase
implements PersistentStateComponent<Element> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    @NotNull
    public final String getRootProfileName() {
        String string = this.getSchemeManager().getCurrentSchemeName();
        if (string == null) {
            string = "Default";
        }
        return string;
    }

    public final void forceInitProfiles(boolean flag) {
        this.setLOAD_PROFILES(flag);
        this.getProfilesAreInitialized().getValue();
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.getSeverityRegistrar().writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.getSeverityRegistrar().readExternal(state);
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile) {
        boolean $i$f$processOpenedProjects = false;
        Project[] projectArray = ProjectManager.getInstanceIfCreated();
        if (projectArray == null || (projectArray = projectArray.getOpenProjects()) == null) {
        } else {
            for (Project project$iv : projectArray) {
                if (project$iv.isDisposed() || !project$iv.isInitialized()) continue;
                Project project = project$iv;
                boolean bl = false;
                ProjectInspectionProfileManager.Companion.getInstance(project).fireProfileChanged(profile);
            }
        }
    }

    @Override
    @Nullable
    public InspectionProfileImpl loadProfile(@NotNull String path) throws IOException, JDOMException {
        try {
            return super.loadProfile(path);
        }
        catch (IOException e) {
            throw (Throwable)e;
        }
        catch (JDOMException e) {
            throw (Throwable)e;
        }
        catch (Exception ignored) {
            Path file2 = Paths.get(path, new String[0]);
            ApplicationManager.getApplication().invokeLater(new Runnable(file2){
                final /* synthetic */ Path $file;

                public final void run() {
                    Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, this.$file}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                }
                {
                    this.$file = path;
                }
            }, ModalityState.NON_MODAL);
            return this.getProfile(path, false);
        }
    }

    @NonInjectable
    public ApplicationInspectionProfileManager(@NotNull SchemeManagerFactory schemeManagerFactory) {
        super(schemeManagerFactory);
        Companion.registerProvidedSeverities();
    }

    public ApplicationInspectionProfileManager() {
        this(SchemeManagerFactory.Companion.getInstance());
    }

    @JvmStatic
    @NotNull
    public static final ApplicationInspectionProfileManager getInstanceImpl() {
        return Companion.getInstanceImpl();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager$Companion;", "", "()V", "getInstanceImpl", "Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager;", "registerProvidedSeverities", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ApplicationInspectionProfileManager getInstanceImpl() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(InspectionProfileManager.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInspection.ex.ApplicationInspectionProfileManager");
            }
            return (ApplicationInspectionProfileManager)object;
        }

        public final void registerProvidedSeverities() {
            HashMap map2 = new HashMap();
            SeveritiesProvider.EP_NAME.forEachExtensionSafe((Consumer)new Consumer<SeveritiesProvider>(map2){
                final /* synthetic */ HashMap $map;

                public final void accept(SeveritiesProvider provider) {
                    for (HighlightInfoType t : provider.getSeveritiesHighlightInfoTypes()) {
                        HighlightSeverity highlightSeverity = t.getSeverity(null);
                        HighlightInfoType highlightInfoType = t;
                        Icon icon2 = highlightInfoType instanceof HighlightInfoType.Iconable ? IconLoader.createLazy((Supplier)new Supplier<Icon>(t){
                            final /* synthetic */ HighlightInfoType $t;

                            public final Icon get() {
                                HighlightInfoType highlightInfoType = this.$t;
                                if (highlightInfoType == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.HighlightInfoType.Iconable");
                                }
                                return ((HighlightInfoType.Iconable)((Object)highlightInfoType)).getIcon();
                            }
                            {
                                this.$t = highlightInfoType;
                            }
                        }) : null;
                        this.$map.put(highlightSeverity.getName(), t);
                        HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (TextAttributesKey)t.getAttributesKey(), (Icon)icon2);
                    }
                }
                {
                    this.$map = hashMap;
                }
            });
            Map map3 = map2;
            boolean bl = false;
            if (!map3.isEmpty()) {
                SeverityRegistrar.registerStandard(map2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

