/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.AbstractPerformFixesTask;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private final InspectionToolWrapper myToolWrapper;
    private final FileModifier myQuickfix;
    @Nullable
    private final PsiFile myFile;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull FileModifier quickFix, @Nullable PsiFile file2, String text) {
        this.myToolWrapper = toolWrapper;
        this.myQuickfix = quickFix;
        this.myFile = file2;
        this.myText = text;
    }

    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiFile targetFile = this.myFile != null ? this.myFile : file2;
        List descriptions = (List)ProgressManager.getInstance().runProcess(() -> {
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
            return InspectionEngine.runInspectionOnFile(targetFile, this.myToolWrapper, inspectionManager.createNewGlobalContext());
        }, (ProgressIndicator)new DaemonProgressIndicator());
        if (descriptions.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)targetFile)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionUtil.getInstance().applyFixes(project, "Apply Fixes", descriptions, this.myQuickfix.getClass(), this.myQuickfix.startInWriteAction());
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, LangBundle.message((String)"hint.text.unfortunately.currently.available.for.batch.mode", (Object[])new Object[]{this.myText}));
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return !(this.myQuickfix.getClass() == EmptyIntentionAction.class || !this.myQuickfix.startInWriteAction() && !(this.myQuickfix instanceof BatchQuickFix) || editor == null || this.myToolWrapper instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

