/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlobalInspectionUtil {
    private static final String LOC_MARKER = " #loc";

    @NotNull
    public static String createInspectionMessage(@NotNull String message) {
        return message + LOC_MARKER;
    }

    public static void createProblem(@NotNull PsiElement elt, @NotNull HighlightInfo info, TextRange range2, @Nullable ProblemGroup problemGroup, @NotNull InspectionManager manager, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor, @NotNull GlobalInspectionContext globalContext) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (info.quickFixActionRanges != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> actionRange : info.quickFixActionRanges) {
                IntentionAction action2 = ((HighlightInfo.IntentionActionDescriptor)actionRange.getFirst()).getAction();
                if (!(action2 instanceof LocalQuickFix)) continue;
                fixes.add((LocalQuickFix)action2);
            }
        }
        ProblemDescriptor descriptor2 = manager.createProblemDescriptor(elt, range2, GlobalInspectionUtil.createInspectionMessage(StringUtil.notNullize((String)info.getDescription())), HighlightInfo.convertType(info.type), false, fixes.isEmpty() ? null : fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        descriptor2.setProblemGroup(problemGroup);
        problemDescriptionsProcessor.addProblemElement((RefEntity)GlobalInspectionContextUtil.retrieveRefElement(elt, globalContext), new CommonProblemDescriptor[]{descriptor2});
    }
}

