/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUnwrapper<C extends AbstractContext>
implements Unwrapper {
    @NotNull
    private final String myDescription;

    public AbstractUnwrapper(@NotNull String description) {
        this.myDescription = description;
    }

    @Override
    public abstract boolean isApplicableTo(@NotNull PsiElement var1);

    @Override
    public void collectElementsToIgnore(@NotNull PsiElement element2, @NotNull Set<PsiElement> result2) {
    }

    @Override
    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        return this.myDescription;
    }

    @Override
    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        try {
            C c = this.createContext();
            this.doUnwrap(e, c);
            toExtract.addAll(((AbstractContext)c).myElementsToExtract);
            return e;
        }
        catch (IncorrectOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        C c = this.createContext();
        ((AbstractContext)c).myIsEffective = true;
        this.doUnwrap(element2, c);
        return ((AbstractContext)c).myElementsToExtract;
    }

    protected abstract void doUnwrap(PsiElement var1, C var2) throws IncorrectOperationException;

    protected abstract C createContext();

    public static abstract class AbstractContext {
        protected final List<PsiElement> myElementsToExtract = new ArrayList<PsiElement>();
        protected boolean myIsEffective;

        public void addElementToExtract(PsiElement e) {
            this.myElementsToExtract.add(e);
        }

        public void extractElement(PsiElement element2, PsiElement from) throws IncorrectOperationException {
            this.extract(element2, element2, from);
        }

        protected abstract boolean isWhiteSpace(PsiElement var1);

        protected void extract(PsiElement first, PsiElement last, PsiElement from) throws IncorrectOperationException {
            while (first != last && this.isWhiteSpace(first)) {
                first = first.getNextSibling();
            }
            while (last != first && this.isWhiteSpace(last)) {
                last = last.getPrevSibling();
            }
            if (first == null || last == null || first == last && this.isWhiteSpace(last)) {
                return;
            }
            PsiElement toExtract = first;
            if (this.myIsEffective) {
                toExtract = this.addRangeBefore(first, last, from.getParent(), from);
            }
            do {
                if (toExtract == null) continue;
                this.addElementToExtract(toExtract);
                toExtract = toExtract.getNextSibling();
            } while ((first = first.getNextSibling()) != null && first.getPrevSibling() != last);
        }

        protected PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, @NotNull PsiElement parent, @NotNull PsiElement anchor2) throws IncorrectOperationException {
            return parent.addRangeBefore(first, last, anchor2);
        }

        public void delete(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.delete();
            }
        }

        public void deleteExactly(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.getParent().deleteChildRange(e, e);
            }
        }

        public final boolean isEffective() {
            return this.myIsEffective;
        }
    }
}

