/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateExpressionSelectorBase
implements PostfixTemplateExpressionSelector {
    @NotNull
    protected final Condition<PsiElement> myAdditionalCondition;
    private static final Condition<PsiElement> PSI_ERROR_FILTER = element2 -> !PsiTreeUtil.hasErrorElements((PsiElement)element2);

    public PostfixTemplateExpressionSelectorBase(@Nullable Condition<PsiElement> condition) {
        this.myAdditionalCondition = condition != null ? condition : Conditions.alwaysTrue();
    }

    @Override
    public boolean hasExpression(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        return !this.getExpressions(context, copyDocument, newOffset).isEmpty();
    }

    protected Condition<PsiElement> getBorderOffsetFilter(int offset) {
        return element2 -> element2.getTextRange().getEndOffset() == offset;
    }

    @Override
    @NotNull
    public List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
        return ContainerUtil.filter(this.getNonFilteredExpressions(context, document, offset), this.getFilters(offset));
    }

    @Override
    @NotNull
    public Function<PsiElement, String> getRenderer() {
        return element2 -> element2.getText();
    }

    protected abstract List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    protected Condition<PsiElement> getFilters(int offset) {
        return Conditions.and(this.getBorderOffsetFilter(offset), this.myAdditionalCondition);
    }

    protected Condition<PsiElement> getPsiErrorFilter() {
        return PSI_ERROR_FILTER;
    }
}

