/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Macro;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MacroFactory {
    private static final MultiMap<String, Macro> myMacroTable = MacroFactory.init();

    public static Macro createMacro(@NonNls String name) {
        return (Macro)ContainerUtil.getFirstItem((Collection)myMacroTable.get((Object)name));
    }

    public static List<Macro> getMacros(@NonNls String name) {
        return (List)myMacroTable.get((Object)name);
    }

    public static Macro[] getMacros() {
        Collection values2 = myMacroTable.values();
        return values2.toArray(new Macro[0]);
    }

    private static MultiMap<String, Macro> init() {
        MultiMap result2 = MultiMap.create();
        for (Macro macro : Macro.EP_NAME.getExtensionList()) {
            result2.putValue((Object)macro.getName(), (Object)macro);
        }
        Macro.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<Macro>(){

            public void extensionAdded(@NotNull Macro extension, @NotNull PluginDescriptor pluginDescriptor) {
                myMacroTable.putValue((Object)extension.getName(), (Object)extension);
            }

            public void extensionRemoved(@NotNull Macro extension, @NotNull PluginDescriptor pluginDescriptor) {
                myMacroTable.remove((Object)extension.getName(), (Object)extension);
            }
        }, (Disposable)ApplicationManager.getApplication());
        return result2;
    }
}

