/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilePathMacroBase
extends Macro {
    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        VirtualFile virtualFile;
        PsiFile file2;
        Project project = context.getProject();
        Editor editor = context.getEditor();
        if (editor != null && (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && (virtualFile = file2.getVirtualFile()) != null) {
            return this.calculateResult(virtualFile, project);
        }
        return null;
    }

    @Nullable
    protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return new TextResult(virtualFile.getName());
    }

    public static class FileRelativePathMacro
    extends FilePathMacroBase {
        public String getName() {
            return "fileRelativePath";
        }

        public String getPresentableName() {
            return "fileRelativePath()";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            return new TextResult(FileUtil.toSystemDependentName((String)CopyReferenceUtil.getVirtualFileFqn(virtualFile, project)));
        }
    }

    public static class FilePathMacro
    extends FilePathMacroBase {
        public String getName() {
            return "filePath";
        }

        public String getPresentableName() {
            return "filePath()";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            return new TextResult(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }
    }

    public static class FileNameMacro
    extends FilePathMacroBase {
        public String getName() {
            return "fileName";
        }

        public String getPresentableName() {
            return CodeInsightBundle.message((String)"macro.file.name", (Object[])new Object[0]);
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            return new TextResult(virtualFile.getName());
        }
    }

    public static class FileNameWithoutExtensionMacro
    extends FilePathMacroBase {
        public String getName() {
            return "fileNameWithoutExtension";
        }

        public String getPresentableName() {
            return CodeInsightBundle.message((String)"macro.file.name.without.extension", (Object[])new Object[0]);
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            return new TextResult(virtualFile.getNameWithoutExtension());
        }
    }
}

